// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object describing a Kinesis video stream.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct StreamInfo {
    /// <p>The name of the device that is associated with the stream.</p>
    pub device_name: ::std::option::Option<::std::string::String>,
    /// <p>The name of the stream.</p>
    pub stream_name: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
    /// <p>The <code>MediaType</code> of the stream.</p>
    pub media_type: ::std::option::Option<::std::string::String>,
    /// <p>The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.</p>
    pub kms_key_id: ::std::option::Option<::std::string::String>,
    /// <p>The version of the stream.</p>
    pub version: ::std::option::Option<::std::string::String>,
    /// <p>The status of the stream.</p>
    pub status: ::std::option::Option<crate::types::Status>,
    /// <p>A time stamp that indicates when the stream was created.</p>
    pub creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>How long the stream retains data, in hours.</p>
    pub data_retention_in_hours: ::std::option::Option<i32>,
}
impl StreamInfo {
    /// <p>The name of the device that is associated with the stream.</p>
    pub fn device_name(&self) -> ::std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The name of the stream.</p>
    pub fn stream_name(&self) -> ::std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The <code>MediaType</code> of the stream.</p>
    pub fn media_type(&self) -> ::std::option::Option<&str> {
        self.media_type.as_deref()
    }
    /// <p>The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.</p>
    pub fn kms_key_id(&self) -> ::std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The version of the stream.</p>
    pub fn version(&self) -> ::std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The status of the stream.</p>
    pub fn status(&self) -> ::std::option::Option<&crate::types::Status> {
        self.status.as_ref()
    }
    /// <p>A time stamp that indicates when the stream was created.</p>
    pub fn creation_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>How long the stream retains data, in hours.</p>
    pub fn data_retention_in_hours(&self) -> ::std::option::Option<i32> {
        self.data_retention_in_hours
    }
}
impl StreamInfo {
    /// Creates a new builder-style object to manufacture [`StreamInfo`](crate::types::StreamInfo).
    pub fn builder() -> crate::types::builders::StreamInfoBuilder {
        crate::types::builders::StreamInfoBuilder::default()
    }
}

/// A builder for [`StreamInfo`](crate::types::StreamInfo).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct StreamInfoBuilder {
    pub(crate) device_name: ::std::option::Option<::std::string::String>,
    pub(crate) stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    pub(crate) media_type: ::std::option::Option<::std::string::String>,
    pub(crate) kms_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) version: ::std::option::Option<::std::string::String>,
    pub(crate) status: ::std::option::Option<crate::types::Status>,
    pub(crate) creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) data_retention_in_hours: ::std::option::Option<i32>,
}
impl StreamInfoBuilder {
    /// <p>The name of the device that is associated with the stream.</p>
    pub fn device_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.device_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the device that is associated with the stream.</p>
    pub fn set_device_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.device_name = input;
        self
    }
    /// <p>The name of the device that is associated with the stream.</p>
    pub fn get_device_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.device_name
    }
    /// <p>The name of the stream.</p>
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the stream.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_name = input;
        self
    }
    /// <p>The name of the stream.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_name
    }
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// <p>The <code>MediaType</code> of the stream.</p>
    pub fn media_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.media_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The <code>MediaType</code> of the stream.</p>
    pub fn set_media_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.media_type = input;
        self
    }
    /// <p>The <code>MediaType</code> of the stream.</p>
    pub fn get_media_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.media_type
    }
    /// <p>The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.</p>
    pub fn kms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.kms_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.</p>
    pub fn set_kms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.kms_key_id = input;
        self
    }
    /// <p>The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.</p>
    pub fn get_kms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.kms_key_id
    }
    /// <p>The version of the stream.</p>
    pub fn version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version of the stream.</p>
    pub fn set_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.version = input;
        self
    }
    /// <p>The version of the stream.</p>
    pub fn get_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.version
    }
    /// <p>The status of the stream.</p>
    pub fn status(mut self, input: crate::types::Status) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of the stream.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::Status>) -> Self {
        self.status = input;
        self
    }
    /// <p>The status of the stream.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::Status> {
        &self.status
    }
    /// <p>A time stamp that indicates when the stream was created.</p>
    pub fn creation_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.creation_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>A time stamp that indicates when the stream was created.</p>
    pub fn set_creation_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.creation_time = input;
        self
    }
    /// <p>A time stamp that indicates when the stream was created.</p>
    pub fn get_creation_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.creation_time
    }
    /// <p>How long the stream retains data, in hours.</p>
    pub fn data_retention_in_hours(mut self, input: i32) -> Self {
        self.data_retention_in_hours = ::std::option::Option::Some(input);
        self
    }
    /// <p>How long the stream retains data, in hours.</p>
    pub fn set_data_retention_in_hours(mut self, input: ::std::option::Option<i32>) -> Self {
        self.data_retention_in_hours = input;
        self
    }
    /// <p>How long the stream retains data, in hours.</p>
    pub fn get_data_retention_in_hours(&self) -> &::std::option::Option<i32> {
        &self.data_retention_in_hours
    }
    /// Consumes the builder and constructs a [`StreamInfo`](crate::types::StreamInfo).
    pub fn build(self) -> crate::types::StreamInfo {
        crate::types::StreamInfo {
            device_name: self.device_name,
            stream_name: self.stream_name,
            stream_arn: self.stream_arn,
            media_type: self.media_type,
            kms_key_id: self.kms_key_id,
            version: self.version,
            status: self.status,
            creation_time: self.creation_time,
            data_retention_in_hours: self.data_retention_in_hours,
        }
    }
}
