// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object that describes the endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
/// <p>The media server endpoint will correspond to the <code>WEBRTC</code> Protocol.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ResourceEndpointListItem {
    /// <p>The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub protocol: ::std::option::Option<crate::types::ChannelProtocol>,
    /// <p>The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub resource_endpoint: ::std::option::Option<::std::string::String>,
}
impl ResourceEndpointListItem {
    /// <p>The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub fn protocol(&self) -> ::std::option::Option<&crate::types::ChannelProtocol> {
        self.protocol.as_ref()
    }
    /// <p>The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub fn resource_endpoint(&self) -> ::std::option::Option<&str> {
        self.resource_endpoint.as_deref()
    }
}
impl ResourceEndpointListItem {
    /// Creates a new builder-style object to manufacture [`ResourceEndpointListItem`](crate::types::ResourceEndpointListItem).
    pub fn builder() -> crate::types::builders::ResourceEndpointListItemBuilder {
        crate::types::builders::ResourceEndpointListItemBuilder::default()
    }
}

/// A builder for [`ResourceEndpointListItem`](crate::types::ResourceEndpointListItem).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ResourceEndpointListItemBuilder {
    pub(crate) protocol: ::std::option::Option<crate::types::ChannelProtocol>,
    pub(crate) resource_endpoint: ::std::option::Option<::std::string::String>,
}
impl ResourceEndpointListItemBuilder {
    /// <p>The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub fn protocol(mut self, input: crate::types::ChannelProtocol) -> Self {
        self.protocol = ::std::option::Option::Some(input);
        self
    }
    /// <p>The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub fn set_protocol(mut self, input: ::std::option::Option<crate::types::ChannelProtocol>) -> Self {
        self.protocol = input;
        self
    }
    /// <p>The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub fn get_protocol(&self) -> &::std::option::Option<crate::types::ChannelProtocol> {
        &self.protocol
    }
    /// <p>The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub fn resource_endpoint(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_endpoint = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub fn set_resource_endpoint(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_endpoint = input;
        self
    }
    /// <p>The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>
    pub fn get_resource_endpoint(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_endpoint
    }
    /// Consumes the builder and constructs a [`ResourceEndpointListItem`](crate::types::ResourceEndpointListItem).
    pub fn build(self) -> crate::types::ResourceEndpointListItem {
        crate::types::ResourceEndpointListItem {
            protocol: self.protocol,
            resource_endpoint: self.resource_endpoint,
        }
    }
}
