// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The recorder configuration consists of the local <code>MediaSourceConfig</code> details that are used as credentials to accesss the local media files streamed on the camera.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RecorderConfig {
    /// <p>The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and <code>MediaUriType</code>) to access the media files streamed to the camera.</p>
    pub media_source_config: ::std::option::Option<crate::types::MediaSourceConfig>,
    /// <p>The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to recording mode.</p>
    pub schedule_config: ::std::option::Option<crate::types::ScheduleConfig>,
}
impl RecorderConfig {
    /// <p>The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and <code>MediaUriType</code>) to access the media files streamed to the camera.</p>
    pub fn media_source_config(&self) -> ::std::option::Option<&crate::types::MediaSourceConfig> {
        self.media_source_config.as_ref()
    }
    /// <p>The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to recording mode.</p>
    pub fn schedule_config(&self) -> ::std::option::Option<&crate::types::ScheduleConfig> {
        self.schedule_config.as_ref()
    }
}
impl RecorderConfig {
    /// Creates a new builder-style object to manufacture [`RecorderConfig`](crate::types::RecorderConfig).
    pub fn builder() -> crate::types::builders::RecorderConfigBuilder {
        crate::types::builders::RecorderConfigBuilder::default()
    }
}

/// A builder for [`RecorderConfig`](crate::types::RecorderConfig).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct RecorderConfigBuilder {
    pub(crate) media_source_config: ::std::option::Option<crate::types::MediaSourceConfig>,
    pub(crate) schedule_config: ::std::option::Option<crate::types::ScheduleConfig>,
}
impl RecorderConfigBuilder {
    /// <p>The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and <code>MediaUriType</code>) to access the media files streamed to the camera.</p>
    /// This field is required.
    pub fn media_source_config(mut self, input: crate::types::MediaSourceConfig) -> Self {
        self.media_source_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and <code>MediaUriType</code>) to access the media files streamed to the camera.</p>
    pub fn set_media_source_config(mut self, input: ::std::option::Option<crate::types::MediaSourceConfig>) -> Self {
        self.media_source_config = input;
        self
    }
    /// <p>The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and <code>MediaUriType</code>) to access the media files streamed to the camera.</p>
    pub fn get_media_source_config(&self) -> &::std::option::Option<crate::types::MediaSourceConfig> {
        &self.media_source_config
    }
    /// <p>The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to recording mode.</p>
    pub fn schedule_config(mut self, input: crate::types::ScheduleConfig) -> Self {
        self.schedule_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to recording mode.</p>
    pub fn set_schedule_config(mut self, input: ::std::option::Option<crate::types::ScheduleConfig>) -> Self {
        self.schedule_config = input;
        self
    }
    /// <p>The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to recording mode.</p>
    pub fn get_schedule_config(&self) -> &::std::option::Option<crate::types::ScheduleConfig> {
        &self.schedule_config
    }
    /// Consumes the builder and constructs a [`RecorderConfig`](crate::types::RecorderConfig).
    pub fn build(self) -> crate::types::RecorderConfig {
        crate::types::RecorderConfig {
            media_source_config: self.media_source_config,
            schedule_config: self.schedule_config,
        }
    }
}
