// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object that contains the latest status details for an edge agent's recorder and uploader jobs. Use this information to determine the current health of an edge agent.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct EdgeAgentStatus {
    /// <p>The latest status of a stream’s edge recording job.</p>
    pub last_recorder_status: ::std::option::Option<crate::types::LastRecorderStatus>,
    /// <p>The latest status of a stream’s edge to cloud uploader job.</p>
    pub last_uploader_status: ::std::option::Option<crate::types::LastUploaderStatus>,
}
impl EdgeAgentStatus {
    /// <p>The latest status of a stream’s edge recording job.</p>
    pub fn last_recorder_status(&self) -> ::std::option::Option<&crate::types::LastRecorderStatus> {
        self.last_recorder_status.as_ref()
    }
    /// <p>The latest status of a stream’s edge to cloud uploader job.</p>
    pub fn last_uploader_status(&self) -> ::std::option::Option<&crate::types::LastUploaderStatus> {
        self.last_uploader_status.as_ref()
    }
}
impl EdgeAgentStatus {
    /// Creates a new builder-style object to manufacture [`EdgeAgentStatus`](crate::types::EdgeAgentStatus).
    pub fn builder() -> crate::types::builders::EdgeAgentStatusBuilder {
        crate::types::builders::EdgeAgentStatusBuilder::default()
    }
}

/// A builder for [`EdgeAgentStatus`](crate::types::EdgeAgentStatus).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct EdgeAgentStatusBuilder {
    pub(crate) last_recorder_status: ::std::option::Option<crate::types::LastRecorderStatus>,
    pub(crate) last_uploader_status: ::std::option::Option<crate::types::LastUploaderStatus>,
}
impl EdgeAgentStatusBuilder {
    /// <p>The latest status of a stream’s edge recording job.</p>
    pub fn last_recorder_status(mut self, input: crate::types::LastRecorderStatus) -> Self {
        self.last_recorder_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The latest status of a stream’s edge recording job.</p>
    pub fn set_last_recorder_status(mut self, input: ::std::option::Option<crate::types::LastRecorderStatus>) -> Self {
        self.last_recorder_status = input;
        self
    }
    /// <p>The latest status of a stream’s edge recording job.</p>
    pub fn get_last_recorder_status(&self) -> &::std::option::Option<crate::types::LastRecorderStatus> {
        &self.last_recorder_status
    }
    /// <p>The latest status of a stream’s edge to cloud uploader job.</p>
    pub fn last_uploader_status(mut self, input: crate::types::LastUploaderStatus) -> Self {
        self.last_uploader_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The latest status of a stream’s edge to cloud uploader job.</p>
    pub fn set_last_uploader_status(mut self, input: ::std::option::Option<crate::types::LastUploaderStatus>) -> Self {
        self.last_uploader_status = input;
        self
    }
    /// <p>The latest status of a stream’s edge to cloud uploader job.</p>
    pub fn get_last_uploader_status(&self) -> &::std::option::Option<crate::types::LastUploaderStatus> {
        &self.last_uploader_status
    }
    /// Consumes the builder and constructs a [`EdgeAgentStatus`](crate::types::EdgeAgentStatus).
    pub fn build(self) -> crate::types::EdgeAgentStatus {
        crate::types::EdgeAgentStatus {
            last_recorder_status: self.last_recorder_status,
            last_uploader_status: self.last_uploader_status,
        }
    }
}
