// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct UpdateStreamInput {
    /// <p>The name of the stream whose metadata you want to update.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub stream_name: ::std::option::Option<::std::string::String>,
    /// <p>The ARN of the stream whose metadata you want to update.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
    /// <p>The version of the stream whose metadata you want to update.</p>
    pub current_version: ::std::option::Option<::std::string::String>,
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub device_name: ::std::option::Option<::std::string::String>,
    /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>
    /// <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>
    pub media_type: ::std::option::Option<::std::string::String>,
}
impl UpdateStreamInput {
    /// <p>The name of the stream whose metadata you want to update.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub fn stream_name(&self) -> ::std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The ARN of the stream whose metadata you want to update.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The version of the stream whose metadata you want to update.</p>
    pub fn current_version(&self) -> ::std::option::Option<&str> {
        self.current_version.as_deref()
    }
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub fn device_name(&self) -> ::std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>
    /// <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>
    pub fn media_type(&self) -> ::std::option::Option<&str> {
        self.media_type.as_deref()
    }
}
impl UpdateStreamInput {
    /// Creates a new builder-style object to manufacture [`UpdateStreamInput`](crate::operation::update_stream::UpdateStreamInput).
    pub fn builder() -> crate::operation::update_stream::builders::UpdateStreamInputBuilder {
        crate::operation::update_stream::builders::UpdateStreamInputBuilder::default()
    }
}

/// A builder for [`UpdateStreamInput`](crate::operation::update_stream::UpdateStreamInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct UpdateStreamInputBuilder {
    pub(crate) stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    pub(crate) current_version: ::std::option::Option<::std::string::String>,
    pub(crate) device_name: ::std::option::Option<::std::string::String>,
    pub(crate) media_type: ::std::option::Option<::std::string::String>,
}
impl UpdateStreamInputBuilder {
    /// <p>The name of the stream whose metadata you want to update.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the stream whose metadata you want to update.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_name = input;
        self
    }
    /// <p>The name of the stream whose metadata you want to update.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_name
    }
    /// <p>The ARN of the stream whose metadata you want to update.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ARN of the stream whose metadata you want to update.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The ARN of the stream whose metadata you want to update.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// <p>The version of the stream whose metadata you want to update.</p>
    /// This field is required.
    pub fn current_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.current_version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version of the stream whose metadata you want to update.</p>
    pub fn set_current_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.current_version = input;
        self
    }
    /// <p>The version of the stream whose metadata you want to update.</p>
    pub fn get_current_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.current_version
    }
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub fn device_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.device_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub fn set_device_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.device_name = input;
        self
    }
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub fn get_device_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.device_name
    }
    /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>
    /// <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>
    pub fn media_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.media_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>
    /// <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>
    pub fn set_media_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.media_type = input;
        self
    }
    /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>
    /// <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>
    pub fn get_media_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.media_type
    }
    /// Consumes the builder and constructs a [`UpdateStreamInput`](crate::operation::update_stream::UpdateStreamInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::update_stream::UpdateStreamInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::update_stream::UpdateStreamInput {
            stream_name: self.stream_name,
            stream_arn: self.stream_arn,
            current_version: self.current_version,
            device_name: self.device_name,
            media_type: self.media_type,
        })
    }
}
