// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::list_edge_agent_configurations::_list_edge_agent_configurations_output::ListEdgeAgentConfigurationsOutputBuilder;

pub use crate::operation::list_edge_agent_configurations::_list_edge_agent_configurations_input::ListEdgeAgentConfigurationsInputBuilder;

impl ListEdgeAgentConfigurationsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.list_edge_agent_configurations();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `ListEdgeAgentConfigurations`.
///
/// <p>Returns an array of edge configurations associated with the specified Edge Agent.</p>
/// <p>In the request, you must specify the Edge Agent <code>HubDeviceArn</code>.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct ListEdgeAgentConfigurationsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::list_edge_agent_configurations::builders::ListEdgeAgentConfigurationsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsOutput,
        crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError,
    > for ListEdgeAgentConfigurationsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsOutput,
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl ListEdgeAgentConfigurationsFluentBuilder {
    /// Creates a new `ListEdgeAgentConfigurations`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the ListEdgeAgentConfigurations as a reference.
    pub fn as_input(&self) -> &crate::operation::list_edge_agent_configurations::builders::ListEdgeAgentConfigurationsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurations::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurations::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsOutput,
        crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl Into<crate::config::Builder>) -> Self {
        self.set_config_override(Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::list_edge_agent_configurations::paginator::ListEdgeAgentConfigurationsPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(self) -> crate::operation::list_edge_agent_configurations::paginator::ListEdgeAgentConfigurationsPaginator {
        crate::operation::list_edge_agent_configurations::paginator::ListEdgeAgentConfigurationsPaginator::new(self.handle, self.inner)
    }
    /// <p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>
    pub fn hub_device_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.hub_device_arn(input.into());
        self
    }
    /// <p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>
    pub fn set_hub_device_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_hub_device_arn(input);
        self
    }
    /// <p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>
    pub fn get_hub_device_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_hub_device_arn()
    }
    /// <p>The maximum number of edge configurations to return in the response. The default is 5.</p>
    pub fn max_results(mut self, input: i32) -> Self {
        self.inner = self.inner.max_results(input);
        self
    }
    /// <p>The maximum number of edge configurations to return in the response. The default is 5.</p>
    pub fn set_max_results(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_max_results(input);
        self
    }
    /// <p>The maximum number of edge configurations to return in the response. The default is 5.</p>
    pub fn get_max_results(&self) -> &::std::option::Option<i32> {
        self.inner.get_max_results()
    }
    /// <p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
}
