// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetDataEndpointInput {
    /// <p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>
    pub stream_name: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
    /// <p>The name of the API action for which to get an endpoint.</p>
    pub api_name: ::std::option::Option<crate::types::ApiName>,
}
impl GetDataEndpointInput {
    /// <p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>
    pub fn stream_name(&self) -> ::std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The name of the API action for which to get an endpoint.</p>
    pub fn api_name(&self) -> ::std::option::Option<&crate::types::ApiName> {
        self.api_name.as_ref()
    }
}
impl GetDataEndpointInput {
    /// Creates a new builder-style object to manufacture [`GetDataEndpointInput`](crate::operation::get_data_endpoint::GetDataEndpointInput).
    pub fn builder() -> crate::operation::get_data_endpoint::builders::GetDataEndpointInputBuilder {
        crate::operation::get_data_endpoint::builders::GetDataEndpointInputBuilder::default()
    }
}

/// A builder for [`GetDataEndpointInput`](crate::operation::get_data_endpoint::GetDataEndpointInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct GetDataEndpointInputBuilder {
    pub(crate) stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    pub(crate) api_name: ::std::option::Option<crate::types::ApiName>,
}
impl GetDataEndpointInputBuilder {
    /// <p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_name = input;
        self
    }
    /// <p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_name
    }
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// <p>The name of the API action for which to get an endpoint.</p>
    /// This field is required.
    pub fn api_name(mut self, input: crate::types::ApiName) -> Self {
        self.api_name = ::std::option::Option::Some(input);
        self
    }
    /// <p>The name of the API action for which to get an endpoint.</p>
    pub fn set_api_name(mut self, input: ::std::option::Option<crate::types::ApiName>) -> Self {
        self.api_name = input;
        self
    }
    /// <p>The name of the API action for which to get an endpoint.</p>
    pub fn get_api_name(&self) -> &::std::option::Option<crate::types::ApiName> {
        &self.api_name
    }
    /// Consumes the builder and constructs a [`GetDataEndpointInput`](crate::operation::get_data_endpoint::GetDataEndpointInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::get_data_endpoint::GetDataEndpointInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::get_data_endpoint::GetDataEndpointInput {
            stream_name: self.stream_name,
            stream_arn: self.stream_arn,
            api_name: self.api_name,
        })
    }
}
