// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::types::error::AccessDeniedException),
    /// <p>You have reached the maximum limit of active signaling channels for this Amazon Web Services account in this region.</p>
    AccountChannelLimitExceededException(crate::types::error::AccountChannelLimitExceededException),
    /// <p>The number of streams created for the account is too high.</p>
    AccountStreamLimitExceededException(crate::types::error::AccountStreamLimitExceededException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::types::error::ClientLimitExceededException),
    /// <p>Not implemented.</p>
    DeviceStreamLimitExceededException(crate::types::error::DeviceStreamLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::types::error::InvalidArgumentException),
    /// <p>Not implemented.</p>
    InvalidDeviceException(crate::types::error::InvalidDeviceException),
    /// <p>The format of the <code>StreamARN</code> is invalid.</p>
    InvalidResourceFormatException(crate::types::error::InvalidResourceFormatException),
    /// <p>The Stream data retention in hours is equal to zero.</p>
    NoDataRetentionException(crate::types::error::NoDataRetentionException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::types::error::NotAuthorizedException),
    /// <p>When the input <code>StreamARN</code> or <code>ChannelARN</code> in <code>CLOUD_STORAGE_MODE</code> is already mapped to a different Kinesis Video Stream resource, or if the provided input <code>StreamARN</code> or <code>ChannelARN</code> is not in Active status, try one of the following :</p>
    /// <ol>
    /// <li>
    /// <p>The <code>DescribeMediaStorageConfiguration</code> API to determine what the stream given channel is mapped to.</p></li>
    /// <li>
    /// <p>The <code>DescribeMappedResourceConfiguration</code> API to determine the channel that the given stream is mapped to.</p></li>
    /// <li>
    /// <p>The <code>DescribeStream</code> or <code>DescribeSignalingChannel</code> API to determine the status of the resource.</p></li>
    /// </ol>
    ResourceInUseException(crate::types::error::ResourceInUseException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>The Exception rendered when the Amazon Kinesis Video Stream can't find a stream's edge configuration that you specified.</p>
    StreamEdgeConfigurationNotFoundException(crate::types::error::StreamEdgeConfigurationNotFoundException),
    /// <p>You have exceeded the limit of tags that you can associate with the resource. A Kinesis video stream can support up to 50 tags.</p>
    TagsPerResourceExceededLimitException(crate::types::error::TagsPerResourceExceededLimitException),
    /// <p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>
    VersionMismatchException(crate::types::error::VersionMismatchException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AccountChannelLimitExceededException(inner) => inner.fmt(f),
            Error::AccountStreamLimitExceededException(inner) => inner.fmt(f),
            Error::ClientLimitExceededException(inner) => inner.fmt(f),
            Error::DeviceStreamLimitExceededException(inner) => inner.fmt(f),
            Error::InvalidArgumentException(inner) => inner.fmt(f),
            Error::InvalidDeviceException(inner) => inner.fmt(f),
            Error::InvalidResourceFormatException(inner) => inner.fmt(f),
            Error::NoDataRetentionException(inner) => inner.fmt(f),
            Error::NotAuthorizedException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::StreamEdgeConfigurationNotFoundException(inner) => inner.fmt(f),
            Error::TagsPerResourceExceededLimitException(inner) => inner.fmt(f),
            Error::VersionMismatchException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::AccessDeniedException(inner) => inner.meta(),
            Self::AccountChannelLimitExceededException(inner) => inner.meta(),
            Self::AccountStreamLimitExceededException(inner) => inner.meta(),
            Self::ClientLimitExceededException(inner) => inner.meta(),
            Self::DeviceStreamLimitExceededException(inner) => inner.meta(),
            Self::InvalidArgumentException(inner) => inner.meta(),
            Self::InvalidDeviceException(inner) => inner.meta(),
            Self::InvalidResourceFormatException(inner) => inner.meta(),
            Self::NoDataRetentionException(inner) => inner.meta(),
            Self::NotAuthorizedException(inner) => inner.meta(),
            Self::ResourceInUseException(inner) => inner.meta(),
            Self::ResourceNotFoundException(inner) => inner.meta(),
            Self::StreamEdgeConfigurationNotFoundException(inner) => inner.meta(),
            Self::TagsPerResourceExceededLimitException(inner) => inner.meta(),
            Self::VersionMismatchException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_signaling_channel::CreateSignalingChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_signaling_channel::CreateSignalingChannelError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_signaling_channel::CreateSignalingChannelError> for Error {
    fn from(err: crate::operation::create_signaling_channel::CreateSignalingChannelError) -> Self {
        match err {
            crate::operation::create_signaling_channel::CreateSignalingChannelError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::create_signaling_channel::CreateSignalingChannelError::AccountChannelLimitExceededException(inner) => {
                Error::AccountChannelLimitExceededException(inner)
            }
            crate::operation::create_signaling_channel::CreateSignalingChannelError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::create_signaling_channel::CreateSignalingChannelError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::create_signaling_channel::CreateSignalingChannelError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::create_signaling_channel::CreateSignalingChannelError::TagsPerResourceExceededLimitException(inner) => {
                Error::TagsPerResourceExceededLimitException(inner)
            }
            crate::operation::create_signaling_channel::CreateSignalingChannelError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_stream::CreateStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_stream::CreateStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_stream::CreateStreamError> for Error {
    fn from(err: crate::operation::create_stream::CreateStreamError) -> Self {
        match err {
            crate::operation::create_stream::CreateStreamError::AccountStreamLimitExceededException(inner) => {
                Error::AccountStreamLimitExceededException(inner)
            }
            crate::operation::create_stream::CreateStreamError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::create_stream::CreateStreamError::DeviceStreamLimitExceededException(inner) => {
                Error::DeviceStreamLimitExceededException(inner)
            }
            crate::operation::create_stream::CreateStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::create_stream::CreateStreamError::InvalidDeviceException(inner) => Error::InvalidDeviceException(inner),
            crate::operation::create_stream::CreateStreamError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::create_stream::CreateStreamError::TagsPerResourceExceededLimitException(inner) => {
                Error::TagsPerResourceExceededLimitException(inner)
            }
            crate::operation::create_stream::CreateStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError> for Error {
    fn from(err: crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError) -> Self {
        match err {
            crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError::StreamEdgeConfigurationNotFoundException(inner) => {
                Error::StreamEdgeConfigurationNotFoundException(inner)
            }
            crate::operation::delete_edge_configuration::DeleteEdgeConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_signaling_channel::DeleteSignalingChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_signaling_channel::DeleteSignalingChannelError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_signaling_channel::DeleteSignalingChannelError> for Error {
    fn from(err: crate::operation::delete_signaling_channel::DeleteSignalingChannelError) -> Self {
        match err {
            crate::operation::delete_signaling_channel::DeleteSignalingChannelError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::delete_signaling_channel::DeleteSignalingChannelError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::delete_signaling_channel::DeleteSignalingChannelError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::delete_signaling_channel::DeleteSignalingChannelError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::delete_signaling_channel::DeleteSignalingChannelError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::delete_signaling_channel::DeleteSignalingChannelError::VersionMismatchException(inner) => {
                Error::VersionMismatchException(inner)
            }
            crate::operation::delete_signaling_channel::DeleteSignalingChannelError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_stream::DeleteStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_stream::DeleteStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_stream::DeleteStreamError> for Error {
    fn from(err: crate::operation::delete_stream::DeleteStreamError) -> Self {
        match err {
            crate::operation::delete_stream::DeleteStreamError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::delete_stream::DeleteStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::delete_stream::DeleteStreamError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::delete_stream::DeleteStreamError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::delete_stream::DeleteStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::delete_stream::DeleteStreamError::VersionMismatchException(inner) => Error::VersionMismatchException(inner),
            crate::operation::delete_stream::DeleteStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError> for Error {
    fn from(err: crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError) -> Self {
        match err {
            crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError::StreamEdgeConfigurationNotFoundException(inner) => {
                Error::StreamEdgeConfigurationNotFoundException(inner)
            }
            crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError> for Error {
    fn from(err: crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError) -> Self {
        match err {
            crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError::ClientLimitExceededException(
                inner,
            ) => Error::ClientLimitExceededException(inner),
            crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError::ResourceNotFoundException(
                inner,
            ) => Error::ResourceNotFoundException(inner),
            crate::operation::describe_image_generation_configuration::DescribeImageGenerationConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError> for Error {
    fn from(err: crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError) -> Self {
        match err {
            crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError::ClientLimitExceededException(
                inner,
            ) => Error::ClientLimitExceededException(inner),
            crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::describe_mapped_resource_configuration::DescribeMappedResourceConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError> for Error {
    fn from(err: crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError) -> Self {
        match err {
            crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::describe_media_storage_configuration::DescribeMediaStorageConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError> for Error {
    fn from(err: crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError) -> Self {
        match err {
            crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::describe_notification_configuration::DescribeNotificationConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_signaling_channel::DescribeSignalingChannelError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_signaling_channel::DescribeSignalingChannelError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_signaling_channel::DescribeSignalingChannelError> for Error {
    fn from(err: crate::operation::describe_signaling_channel::DescribeSignalingChannelError) -> Self {
        match err {
            crate::operation::describe_signaling_channel::DescribeSignalingChannelError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::describe_signaling_channel::DescribeSignalingChannelError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::describe_signaling_channel::DescribeSignalingChannelError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::describe_signaling_channel::DescribeSignalingChannelError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::describe_signaling_channel::DescribeSignalingChannelError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_stream::DescribeStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_stream::DescribeStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_stream::DescribeStreamError> for Error {
    fn from(err: crate::operation::describe_stream::DescribeStreamError) -> Self {
        match err {
            crate::operation::describe_stream::DescribeStreamError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::describe_stream::DescribeStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::describe_stream::DescribeStreamError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::describe_stream::DescribeStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::describe_stream::DescribeStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_data_endpoint::GetDataEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_data_endpoint::GetDataEndpointError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_data_endpoint::GetDataEndpointError> for Error {
    fn from(err: crate::operation::get_data_endpoint::GetDataEndpointError) -> Self {
        match err {
            crate::operation::get_data_endpoint::GetDataEndpointError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::get_data_endpoint::GetDataEndpointError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::get_data_endpoint::GetDataEndpointError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::get_data_endpoint::GetDataEndpointError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::get_data_endpoint::GetDataEndpointError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError> for Error {
    fn from(err: crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError) -> Self {
        match err {
            crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::get_signaling_channel_endpoint::GetSignalingChannelEndpointError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError> for Error {
    fn from(err: crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError) -> Self {
        match err {
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError::NotAuthorizedException(inner) => {
                Error::NotAuthorizedException(inner)
            }
            crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_signaling_channels::ListSignalingChannelsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_signaling_channels::ListSignalingChannelsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_signaling_channels::ListSignalingChannelsError> for Error {
    fn from(err: crate::operation::list_signaling_channels::ListSignalingChannelsError) -> Self {
        match err {
            crate::operation::list_signaling_channels::ListSignalingChannelsError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::list_signaling_channels::ListSignalingChannelsError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::list_signaling_channels::ListSignalingChannelsError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::list_signaling_channels::ListSignalingChannelsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_streams::ListStreamsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_streams::ListStreamsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_streams::ListStreamsError> for Error {
    fn from(err: crate::operation::list_streams::ListStreamsError) -> Self {
        match err {
            crate::operation::list_streams::ListStreamsError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::list_streams::ListStreamsError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::list_streams::ListStreamsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_resource::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_resource::ListTagsForResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_tags_for_resource::ListTagsForResourceError> for Error {
    fn from(err: crate::operation::list_tags_for_resource::ListTagsForResourceError) -> Self {
        match err {
            crate::operation::list_tags_for_resource::ListTagsForResourceError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::list_tags_for_resource::ListTagsForResourceError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_stream::ListTagsForStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_stream::ListTagsForStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_tags_for_stream::ListTagsForStreamError> for Error {
    fn from(err: crate::operation::list_tags_for_stream::ListTagsForStreamError) -> Self {
        match err {
            crate::operation::list_tags_for_stream::ListTagsForStreamError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::list_tags_for_stream::ListTagsForStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::list_tags_for_stream::ListTagsForStreamError::InvalidResourceFormatException(inner) => {
                Error::InvalidResourceFormatException(inner)
            }
            crate::operation::list_tags_for_stream::ListTagsForStreamError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::list_tags_for_stream::ListTagsForStreamError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::list_tags_for_stream::ListTagsForStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError> for Error {
    fn from(err: crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError) -> Self {
        match err {
            crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError::NoDataRetentionException(inner) => {
                Error::NoDataRetentionException(inner)
            }
            crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_resource::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_resource::TagResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::tag_resource::TagResourceError> for Error {
    fn from(err: crate::operation::tag_resource::TagResourceError) -> Self {
        match err {
            crate::operation::tag_resource::TagResourceError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::tag_resource::TagResourceError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::tag_resource::TagResourceError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::tag_resource::TagResourceError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::tag_resource::TagResourceError::TagsPerResourceExceededLimitException(inner) => {
                Error::TagsPerResourceExceededLimitException(inner)
            }
            crate::operation::tag_resource::TagResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_stream::TagStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_stream::TagStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::tag_stream::TagStreamError> for Error {
    fn from(err: crate::operation::tag_stream::TagStreamError) -> Self {
        match err {
            crate::operation::tag_stream::TagStreamError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::tag_stream::TagStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::tag_stream::TagStreamError::InvalidResourceFormatException(inner) => Error::InvalidResourceFormatException(inner),
            crate::operation::tag_stream::TagStreamError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::tag_stream::TagStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::tag_stream::TagStreamError::TagsPerResourceExceededLimitException(inner) => {
                Error::TagsPerResourceExceededLimitException(inner)
            }
            crate::operation::tag_stream::TagStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_resource::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_resource::UntagResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::untag_resource::UntagResourceError> for Error {
    fn from(err: crate::operation::untag_resource::UntagResourceError) -> Self {
        match err {
            crate::operation::untag_resource::UntagResourceError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::untag_resource::UntagResourceError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::untag_resource::UntagResourceError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::untag_resource::UntagResourceError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::untag_resource::UntagResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_stream::UntagStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_stream::UntagStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::untag_stream::UntagStreamError> for Error {
    fn from(err: crate::operation::untag_stream::UntagStreamError) -> Self {
        match err {
            crate::operation::untag_stream::UntagStreamError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::untag_stream::UntagStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::untag_stream::UntagStreamError::InvalidResourceFormatException(inner) => Error::InvalidResourceFormatException(inner),
            crate::operation::untag_stream::UntagStreamError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::untag_stream::UntagStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::untag_stream::UntagStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_data_retention::UpdateDataRetentionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_data_retention::UpdateDataRetentionError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_data_retention::UpdateDataRetentionError> for Error {
    fn from(err: crate::operation::update_data_retention::UpdateDataRetentionError) -> Self {
        match err {
            crate::operation::update_data_retention::UpdateDataRetentionError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::update_data_retention::UpdateDataRetentionError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::update_data_retention::UpdateDataRetentionError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::update_data_retention::UpdateDataRetentionError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::update_data_retention::UpdateDataRetentionError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::update_data_retention::UpdateDataRetentionError::VersionMismatchException(inner) => {
                Error::VersionMismatchException(inner)
            }
            crate::operation::update_data_retention::UpdateDataRetentionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError> for Error {
    fn from(err: crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError) -> Self {
        match err {
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError::NoDataRetentionException(inner) => {
                Error::NoDataRetentionException(inner)
            }
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::update_image_generation_configuration::UpdateImageGenerationConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError> for Error {
    fn from(err: crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError) -> Self {
        match err {
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError::NoDataRetentionException(inner) => {
                Error::NoDataRetentionException(inner)
            }
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_notification_configuration::UpdateNotificationConfigurationError> for Error {
    fn from(err: crate::operation::update_notification_configuration::UpdateNotificationConfigurationError) -> Self {
        match err {
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError::NoDataRetentionException(inner) => {
                Error::NoDataRetentionException(inner)
            }
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::update_notification_configuration::UpdateNotificationConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_signaling_channel::UpdateSignalingChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_signaling_channel::UpdateSignalingChannelError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_signaling_channel::UpdateSignalingChannelError> for Error {
    fn from(err: crate::operation::update_signaling_channel::UpdateSignalingChannelError) -> Self {
        match err {
            crate::operation::update_signaling_channel::UpdateSignalingChannelError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::update_signaling_channel::UpdateSignalingChannelError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::update_signaling_channel::UpdateSignalingChannelError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::update_signaling_channel::UpdateSignalingChannelError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::update_signaling_channel::UpdateSignalingChannelError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::update_signaling_channel::UpdateSignalingChannelError::VersionMismatchException(inner) => {
                Error::VersionMismatchException(inner)
            }
            crate::operation::update_signaling_channel::UpdateSignalingChannelError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_stream::UpdateStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_stream::UpdateStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_stream::UpdateStreamError> for Error {
    fn from(err: crate::operation::update_stream::UpdateStreamError) -> Self {
        match err {
            crate::operation::update_stream::UpdateStreamError::ClientLimitExceededException(inner) => Error::ClientLimitExceededException(inner),
            crate::operation::update_stream::UpdateStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::update_stream::UpdateStreamError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::update_stream::UpdateStreamError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::update_stream::UpdateStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::update_stream::UpdateStreamError::VersionMismatchException(inner) => Error::VersionMismatchException(inner),
            crate::operation::update_stream::UpdateStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::AccessDeniedException(inner) => inner.source(),
            Error::AccountChannelLimitExceededException(inner) => inner.source(),
            Error::AccountStreamLimitExceededException(inner) => inner.source(),
            Error::ClientLimitExceededException(inner) => inner.source(),
            Error::DeviceStreamLimitExceededException(inner) => inner.source(),
            Error::InvalidArgumentException(inner) => inner.source(),
            Error::InvalidDeviceException(inner) => inner.source(),
            Error::InvalidResourceFormatException(inner) => inner.source(),
            Error::NoDataRetentionException(inner) => inner.source(),
            Error::NotAuthorizedException(inner) => inner.source(),
            Error::ResourceInUseException(inner) => inner.source(),
            Error::ResourceNotFoundException(inner) => inner.source(),
            Error::StreamEdgeConfigurationNotFoundException(inner) => inner.source(),
            Error::TagsPerResourceExceededLimitException(inner) => inner.source(),
            Error::VersionMismatchException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::AccessDeniedException(e) => e.request_id(),
            Self::AccountChannelLimitExceededException(e) => e.request_id(),
            Self::AccountStreamLimitExceededException(e) => e.request_id(),
            Self::ClientLimitExceededException(e) => e.request_id(),
            Self::DeviceStreamLimitExceededException(e) => e.request_id(),
            Self::InvalidArgumentException(e) => e.request_id(),
            Self::InvalidDeviceException(e) => e.request_id(),
            Self::InvalidResourceFormatException(e) => e.request_id(),
            Self::NoDataRetentionException(e) => e.request_id(),
            Self::NotAuthorizedException(e) => e.request_id(),
            Self::ResourceInUseException(e) => e.request_id(),
            Self::ResourceNotFoundException(e) => e.request_id(),
            Self::StreamEdgeConfigurationNotFoundException(e) => e.request_id(),
            Self::TagsPerResourceExceededLimitException(e) => e.request_id(),
            Self::VersionMismatchException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
