/* Skip the CVE-2024-5535 fix in case the version being livepatched already have a fix for it.  */

#ifndef _DISABLE_CVE_2024_5535

#include <stdint.h>
#include <stdlib.h>

#define ossl_inline inline
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/openssl/crypto.h:445:1  */
int CRYPTO_memcmp(const void * in_a, const void * in_b, size_t len);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/openssl/ssl.h:819:8  */
int SSL_select_next_proto_lp(unsigned char **out, unsigned char *outlen,
                                 const unsigned char *in, unsigned int inlen,
                                 const unsigned char *client,
                                 unsigned int client_len);

#define OPENSSL_NPN_NEGOTIATED  1
#define OPENSSL_NPN_NO_OVERLAP  2
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:22:1  */
typedef struct {
    /* Pointer to where we are currently reading from */
    const unsigned char *curr;
    /* Number of bytes remaining */
    size_t remaining;
} PACKET;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:30:1  */
static ossl_inline void packet_forward(PACKET *pkt, size_t len)
{
    pkt->curr += len;
    pkt->remaining -= len;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:39:1  */
static ossl_inline size_t PACKET_remaining(const PACKET *pkt)
{
    return pkt->remaining;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:59:1  */
static ossl_inline const unsigned char *PACKET_data(const PACKET *pkt)
{
    return pkt->curr;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:69:8  */
static ossl_inline int PACKET_buf_init(PACKET *pkt,
                                              const unsigned char *buf,
                                              size_t len)
{
    /* Sanity check for negative values. */
    if (len > (size_t)(SIZE_MAX / 2))
        return 0;

    pkt->curr = buf;
    pkt->remaining = len;
    return 1;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:94:8  */
static ossl_inline int PACKET_equal(const PACKET *pkt, const void *ptr,
                                           size_t num)
{
    if (PACKET_remaining(pkt) != num)
        return 0;
    return CRYPTO_memcmp(pkt->curr, ptr, num) == 0;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:289:8  */
static ossl_inline int PACKET_peek_1(const PACKET *pkt,
                                            unsigned int *data)
{
    if (!PACKET_remaining(pkt))
        return 0;

    *data = *pkt->curr;

    return 1;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:301:8  */
static ossl_inline int PACKET_get_1(PACKET *pkt, unsigned int *data)
{
    if (!PACKET_peek_1(pkt, data))
        return 0;

    packet_forward(pkt, 1);

    return 1;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:362:8  */
static ossl_inline int PACKET_peek_bytes(const PACKET *pkt,
                                                const unsigned char **data,
                                                size_t len)
{
    if (PACKET_remaining(pkt) < len)
        return 0;

    *data = pkt->curr;

    return 1;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:380:8  */
static ossl_inline int PACKET_get_bytes(PACKET *pkt,
                                               const unsigned char **data,
                                               size_t len)
{
    if (!PACKET_peek_bytes(pkt, data, len))
        return 0;

    packet_forward(pkt, len);

    return 1;
}

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-3.1.4/include/internal/packet.h:514:8  */
static ossl_inline int PACKET_get_length_prefixed_1(PACKET *pkt,
                                                           PACKET *subpkt)
{
    unsigned int length;
    const unsigned char *data;
    PACKET tmp = *pkt;
    if (!PACKET_get_1(&tmp, &length) ||
        !PACKET_get_bytes(&tmp, &data, (size_t)length)) {
        return 0;
    }

    *pkt = tmp;
    subpkt->curr = data;
    subpkt->remaining = length;

    return 1;
}

/** clang-extract: from ssl/ssl_lib.c:2932:1  */
__attribute__((visibility("default")))
int SSL_select_next_proto_lp(unsigned char **out, unsigned char *outlen,
                          const unsigned char *server,
                          unsigned int server_len,
                          const unsigned char *client, unsigned int client_len)
{
    PACKET cpkt, csubpkt, spkt, ssubpkt;

    if (!PACKET_buf_init(&cpkt, client, client_len)
            || !PACKET_get_length_prefixed_1(&cpkt, &csubpkt)
            || PACKET_remaining(&csubpkt) == 0) {
        *out = NULL;
        *outlen = 0;
        return OPENSSL_NPN_NO_OVERLAP;
    }

    /*
     * Set the default opportunistic protocol. Will be overwritten if we find
     * a match.
     */
    *out = (unsigned char *)PACKET_data(&csubpkt);
    *outlen = (unsigned char)PACKET_remaining(&csubpkt);

    /*
     * For each protocol in server preference order, see if we support it.
     */
    if (PACKET_buf_init(&spkt, server, server_len)) {
        while (PACKET_get_length_prefixed_1(&spkt, &ssubpkt)) {
            if (PACKET_remaining(&ssubpkt) == 0)
                continue; /* Invalid - ignore it */
            if (PACKET_buf_init(&cpkt, client, client_len)) {
                while (PACKET_get_length_prefixed_1(&cpkt, &csubpkt)) {
                    if (PACKET_equal(&csubpkt, PACKET_data(&ssubpkt),
                                     PACKET_remaining(&ssubpkt))) {
                        /* We found a match */
                        *out = (unsigned char *)PACKET_data(&ssubpkt);
                        *outlen = (unsigned char)PACKET_remaining(&ssubpkt);
                        return OPENSSL_NPN_NEGOTIATED;
                    }
                }
                /* Ignore spurious trailing bytes in the client list */
            } else {
                /* This should never happen */
                return OPENSSL_NPN_NO_OVERLAP;
            }
        }
        /* Ignore spurious trailing bytes in the server list */
    }

    /*
     * There's no overlap between our protocols and the server's list. We use
     * the default opportunistic protocol selected earlier
     */
    return OPENSSL_NPN_NO_OVERLAP;
}
#endif
