/** clang-extract: from /usr/lib64/clang/20/include/__stddef_size_t.h:18:1 */
typedef __SIZE_TYPE__ size_t;

/** clang-extract: from /usr/include/bits/types.h:41:1 */
typedef signed int __int32_t;

/** clang-extract: from /usr/include/bits/stdint-intn.h:26:1 */
typedef __int32_t int32_t;

#define OPENSSL_FILE __FILE__
#define OPENSSL_LINE __LINE__
#define OPENSSL_FUNC __func__
#define STACK_OF(type) struct stack_st_##type
/** clang-extract: from crypto/cms/cms_env.c:581:9 */
struct asn1_string_st;/* Full definition was removed.  */

/** clang-extract: from include/openssl/types.h:60:1 */
typedef struct asn1_string_st ASN1_OCTET_STRING;

/** clang-extract: from include/openssl/types.h:77:1 */
typedef struct asn1_type_st ASN1_TYPE;

/** clang-extract: from include/openssl/types.h:78:1 */
typedef struct asn1_object_st ASN1_OBJECT;

/** clang-extract: from include/openssl/types.h:104:1 */
typedef struct evp_cipher_st EVP_CIPHER;

/** clang-extract: from include/openssl/types.h:161:1 */
typedef struct X509_algor_st X509_ALGOR;

/** clang-extract: from include/openssl/types.h:218:1 */
typedef struct ossl_lib_ctx_st OSSL_LIB_CTX;

#define NULL ((void*)0)
/** clang-extract: from include/openssl/asn1.h:186:1 */
struct asn1_string_st;/* Full definition was removed.  */

#define ERR_LIB_CMS             46
/** clang-extract: from include/openssl/err.h:395:1 */
void ERR_new(void);

/** clang-extract: from include/openssl/err.h:396:1 */
void ERR_set_debug(const char *file, int line, const char *func);

/** clang-extract: from include/openssl/err.h:397:1 */
void ERR_set_error(int lib, int reason, const char *fmt, ...);

#define ERR_raise(lib, reason) ERR_raise_data((lib),(reason),NULL)
#define ERR_raise_data                                         \
    (ERR_new(),                                                 \
     ERR_set_debug(OPENSSL_FILE,OPENSSL_LINE,OPENSSL_FUNC),     \
     ERR_set_error)
#define NID_pkcs7_enveloped             23
#define NID_id_smime_ct_authEnvelopedData               1059
/** clang-extract: from include/openssl/objects.h:70:1 */
int OBJ_obj2nid(const ASN1_OBJECT *o);

/** clang-extract: from include/openssl/x509.h:179:1 */
struct X509_algor_st;/* Full definition was removed.  */

/** clang-extract: from include/openssl/x509.h:255:1 */
struct stack_st_X509_ATTRIBUTE;/* Full definition was removed.  */

#define CMS_R_CONTENT_TYPE_NOT_ENVELOPED_DATA            107
/** clang-extract: from include/openssl/cms.h:34:1 */
typedef struct CMS_ContentInfo_st CMS_ContentInfo;

/** clang-extract: from include/openssl/cms.h:96:1 */
struct stack_st_CMS_RecipientInfo;/* Full definition was removed.  */

/** clang-extract: from include/openssl/cms.h:122:1 */
struct stack_st_CMS_RevocationInfoChoice;/* Full definition was removed.  */

/** clang-extract: from crypto/cms/cms_local.h:24:1 */
typedef struct CMS_SignedData_st CMS_SignedData;

/** clang-extract: from crypto/cms/cms_local.h:26:1 */
typedef struct CMS_OriginatorInfo_st CMS_OriginatorInfo;

/** clang-extract: from crypto/cms/cms_local.h:27:1 */
typedef struct CMS_EncryptedContentInfo_st CMS_EncryptedContentInfo;

/** clang-extract: from crypto/cms/cms_local.h:28:1 */
typedef struct CMS_EnvelopedData_st CMS_EnvelopedData;

/** clang-extract: from crypto/cms/cms_local.h:29:1 */
typedef struct CMS_DigestedData_st CMS_DigestedData;

/** clang-extract: from crypto/cms/cms_local.h:30:1 */
typedef struct CMS_EncryptedData_st CMS_EncryptedData;

/** clang-extract: from crypto/cms/cms_local.h:31:1 */
typedef struct CMS_AuthenticatedData_st CMS_AuthenticatedData;

/** clang-extract: from crypto/cms/cms_local.h:32:1 */
typedef struct CMS_AuthEnvelopedData_st CMS_AuthEnvelopedData;

/** clang-extract: from crypto/cms/cms_local.h:33:1 */
typedef struct CMS_CompressedData_st CMS_CompressedData;

/** clang-extract: from crypto/cms/cms_local.h:47:1 */
typedef struct CMS_CTX_st CMS_CTX;

/** clang-extract: from crypto/cms/cms_local.h:49:1 */
struct CMS_CTX_st {
    OSSL_LIB_CTX *libctx;
    char *propq;
};

/** clang-extract: from crypto/cms/cms_local.h:54:1 */
struct CMS_ContentInfo_st {
    ASN1_OBJECT *contentType;
    union {
        ASN1_OCTET_STRING *data;
        CMS_SignedData *signedData;
        CMS_EnvelopedData *envelopedData;
        CMS_DigestedData *digestedData;
        CMS_EncryptedData *encryptedData;
        CMS_AuthEnvelopedData *authEnvelopedData;
        CMS_AuthenticatedData *authenticatedData;
        CMS_CompressedData *compressedData;
        ASN1_TYPE *other;
        /* Other types ... */
        void *otherData;
    } d;
    CMS_CTX ctx;
};

/** clang-extract: from crypto/cms/cms_local.h:72:1 */
struct stack_st_CMS_CertificateChoices;/* Full definition was removed.  */

/** clang-extract: from crypto/cms/cms_local.h:115:1 */
struct CMS_EnvelopedData_st {
    int32_t version;
    CMS_OriginatorInfo *originatorInfo;
    STACK_OF(CMS_RecipientInfo) *recipientInfos;
    CMS_EncryptedContentInfo *encryptedContentInfo;
    STACK_OF(X509_ATTRIBUTE) *unprotectedAttrs;
};

/** clang-extract: from crypto/cms/cms_local.h:123:1 */
struct CMS_OriginatorInfo_st;/* Full definition was removed.  */

/** clang-extract: from crypto/cms/cms_local.h:128:1 */
struct CMS_EncryptedContentInfo_st;/* Full definition was removed.  */

/** clang-extract: from crypto/cms/cms_local.h:276:1 */
struct CMS_AuthEnvelopedData_st {
    int32_t version;
    CMS_OriginatorInfo *originatorInfo;
    STACK_OF(CMS_RecipientInfo) *recipientInfos;
    CMS_EncryptedContentInfo *authEncryptedContentInfo;
    STACK_OF(X509_ATTRIBUTE) *authAttrs;
    ASN1_OCTET_STRING *mac;
    STACK_OF(X509_ATTRIBUTE) *unauthAttrs;
};

/** clang-extract: from crypto/cms/cms_local.h:450:1 */
CMS_EncryptedContentInfo *ossl_cms_get0_env_enc_content(const CMS_ContentInfo *cms);

#define CMS_ENVELOPED_STANDARD 1
#define CMS_ENVELOPED_AUTH     2
/** clang-extract: from crypto/cms/cms_env.c:29:1 */
static int cms_get_enveloped_type_simple(const CMS_ContentInfo *cms)
{
    int nid = OBJ_obj2nid(cms->contentType);

    switch (nid) {
    case NID_pkcs7_enveloped:
        return CMS_ENVELOPED_STANDARD;

    case NID_id_smime_ct_authEnvelopedData:
        return CMS_ENVELOPED_AUTH;

    default:
        return 0;
    }
}

/** clang-extract: from crypto/cms/cms_env.c:45:1 */
static int cms_get_enveloped_type(const CMS_ContentInfo *cms)
{
    int ret = cms_get_enveloped_type_simple(cms);

    if (ret == 0)
        ERR_raise(ERR_LIB_CMS, CMS_R_CONTENT_TYPE_NOT_ENVELOPED_DATA);
    return ret;
}

/** clang-extract: from crypto/cms/cms_env.c:158:1 */
CMS_EncryptedContentInfo *ossl_cms_get0_env_enc_content(const CMS_ContentInfo *cms)
{
    switch (cms_get_enveloped_type(cms)) {
    case CMS_ENVELOPED_STANDARD:
        return cms->d.envelopedData == NULL ? NULL
            : cms->d.envelopedData->encryptedContentInfo;

    case CMS_ENVELOPED_AUTH:
        return cms->d.authEnvelopedData == NULL ? NULL
            : cms->d.authEnvelopedData->authEncryptedContentInfo;

    default:
        return NULL;
    }
}

