; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=riscv64 -mattr=+m,+zba,+zbb,+zcb | FileCheck %s

define i64 @c_not(i64 %x, i64 %y, i64 %z) {
; CHECK-LABEL: c_not:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a1, a1
; CHECK-NEXT:    li a0, 1234
; CHECK-NEXT:    mul a0, a0, a1
; CHECK-NEXT:    ret
  %a = xor i64 %y, -1
  %b = mul i64 %a, 1234
  ret i64 %b
}

define i64 @c_mul(i64 %x, i64 %y, i64 %z, i64 %w) {
; CHECK-LABEL: c_mul:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mul a1, a1, a2
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    ret
  %a = mul i64 %y, %z
  %b = or i64 %a, 4096
  ret i64 %b
}

define i64 @c_sext_b(i64 %x, i8 %y, i64 %z) {
; CHECK-LABEL: c_sext_b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sext.b a1, a1
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    ret
  %a = sext i8 %y to i64
  %b = or i64 %a, 4096
  ret i64 %b
}

define i64 @c_sext_h(i64 %x, i16 %y, i64 %z) {
; CHECK-LABEL: c_sext_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sext.h a1, a1
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    ret
  %a = sext i16 %y to i64
  %b = or i64 %a, 4096
  ret i64 %b
}

define i64 @c_zext_b(i64 %x, i8 %y, i64 %z) {
; CHECK-LABEL: c_zext_b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a1, a1, 255
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    ret
  %a = zext i8 %y to i64
  %b = or i64 %a, 4096
  ret i64 %b
}

define i64 @c_zext_h(i64 %x, i16 %y) {
; CHECK-LABEL: c_zext_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    zext.h a1, a1
; CHECK-NEXT:    lui a0, 4096
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    ret
  %a = zext i16 %y to i64
  %b = or i64 %a, 16777216
  ret i64 %b
}

define i64 @c_zext_w(i64 %x, i32 %y) {
; CHECK-LABEL: c_zext_w:
; CHECK:       # %bb.0:
; CHECK-NEXT:    zext.w a1, a1
; CHECK-NEXT:    li a0, 1234
; CHECK-NEXT:    mul a0, a0, a1
; CHECK-NEXT:    ret
  %a = zext i32 %y to i64
  %b = mul i64 %a, 1234
  ret i64 %b
}
