// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "k8s.io/api/core/v1"
)

// WebTLSConfigApplyConfiguration represents an declarative configuration of the WebTLSConfig type for use
// with apply.
type WebTLSConfigApplyConfiguration struct {
	KeySecret                *v1.SecretKeySelector                `json:"keySecret,omitempty"`
	Cert                     *SecretOrConfigMapApplyConfiguration `json:"cert,omitempty"`
	ClientAuthType           *string                              `json:"clientAuthType,omitempty"`
	ClientCA                 *SecretOrConfigMapApplyConfiguration `json:"client_ca,omitempty"`
	MinVersion               *string                              `json:"minVersion,omitempty"`
	MaxVersion               *string                              `json:"maxVersion,omitempty"`
	CipherSuites             []string                             `json:"cipherSuites,omitempty"`
	PreferServerCipherSuites *bool                                `json:"preferServerCipherSuites,omitempty"`
	CurvePreferences         []string                             `json:"curvePreferences,omitempty"`
}

// WebTLSConfigApplyConfiguration constructs an declarative configuration of the WebTLSConfig type for use with
// apply.
func WebTLSConfig() *WebTLSConfigApplyConfiguration {
	return &WebTLSConfigApplyConfiguration{}
}

// WithKeySecret sets the KeySecret field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the KeySecret field is set to the value of the last call.
func (b *WebTLSConfigApplyConfiguration) WithKeySecret(value v1.SecretKeySelector) *WebTLSConfigApplyConfiguration {
	b.KeySecret = &value
	return b
}

// WithCert sets the Cert field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Cert field is set to the value of the last call.
func (b *WebTLSConfigApplyConfiguration) WithCert(value *SecretOrConfigMapApplyConfiguration) *WebTLSConfigApplyConfiguration {
	b.Cert = value
	return b
}

// WithClientAuthType sets the ClientAuthType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientAuthType field is set to the value of the last call.
func (b *WebTLSConfigApplyConfiguration) WithClientAuthType(value string) *WebTLSConfigApplyConfiguration {
	b.ClientAuthType = &value
	return b
}

// WithClientCA sets the ClientCA field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientCA field is set to the value of the last call.
func (b *WebTLSConfigApplyConfiguration) WithClientCA(value *SecretOrConfigMapApplyConfiguration) *WebTLSConfigApplyConfiguration {
	b.ClientCA = value
	return b
}

// WithMinVersion sets the MinVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinVersion field is set to the value of the last call.
func (b *WebTLSConfigApplyConfiguration) WithMinVersion(value string) *WebTLSConfigApplyConfiguration {
	b.MinVersion = &value
	return b
}

// WithMaxVersion sets the MaxVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxVersion field is set to the value of the last call.
func (b *WebTLSConfigApplyConfiguration) WithMaxVersion(value string) *WebTLSConfigApplyConfiguration {
	b.MaxVersion = &value
	return b
}

// WithCipherSuites adds the given value to the CipherSuites field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CipherSuites field.
func (b *WebTLSConfigApplyConfiguration) WithCipherSuites(values ...string) *WebTLSConfigApplyConfiguration {
	for i := range values {
		b.CipherSuites = append(b.CipherSuites, values[i])
	}
	return b
}

// WithPreferServerCipherSuites sets the PreferServerCipherSuites field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PreferServerCipherSuites field is set to the value of the last call.
func (b *WebTLSConfigApplyConfiguration) WithPreferServerCipherSuites(value bool) *WebTLSConfigApplyConfiguration {
	b.PreferServerCipherSuites = &value
	return b
}

// WithCurvePreferences adds the given value to the CurvePreferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CurvePreferences field.
func (b *WebTLSConfigApplyConfiguration) WithCurvePreferences(values ...string) *WebTLSConfigApplyConfiguration {
	for i := range values {
		b.CurvePreferences = append(b.CurvePreferences, values[i])
	}
	return b
}
