# Datadog Receiver

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [alpha]: traces, metrics   |
| Distributions | [contrib] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Areceiver%2Fdatadog%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Areceiver%2Fdatadog) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Areceiver%2Fdatadog%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Areceiver%2Fdatadog) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@boostchicken](https://www.github.com/boostchicken), [@gouthamve](https://www.github.com/gouthamve), [@MovieStoreGuy](https://www.github.com/MovieStoreGuy) |

[alpha]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#alpha
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
<!-- end autogenerated section -->

## Overview

The Datadog receiver enables translation between Datadog and OpenTelemetry-compatible backends.
It currently has support for Datadog's APM traces and Datadog metrics.

## Configuration

Configuration wise is very simple, just need to specify where the Datadog receiver should listen and the read timeout.

Then, the receiver must be configured in the pipeline where it will be used.


```yaml
receivers:
  datadog:
    endpoint: localhost:8126
    read_timeout: 60s

exporters:
  debug:

service:
  pipelines:
    metrics:
      receivers: [datadog]
      exporters: [debug]
    traces:
      receivers: [datadog]
      exporters: [debug]
```

### read_timeout (Optional)
The read timeout of the HTTP Server

Default: 60s

### HTTP Service Config

All config params here are valid as well

https://github.com/open-telemetry/opentelemetry-collector/tree/main/config/confighttp#server-configuration

### Default Attributes

- `dd.span.Resource`: The datadog resource name (as distinct from the span name)

### Optional Attributes

- `_dd.span_links`: This receiver supports DD Agent's `_dd.span_links` attribute for span links creation, as produced by Datadog's tracing libraries. 
Format example can be found [here](./internal/translator/traces_translator_test.go).

### Datadog's API support

**Traces**

| Datadog API Endpoint | Status  | Notes                        |
|----------------------|---------|------------------------------|
| /v0.3/traces         | Alpha   | Support for msgpack and json |
| /v0.4/traces         | Alpha   | Support for msgpack and json |
| /v0.5/traces         | Alpha   | Msgpack custom format        |
| /v0.7/traces         | Alpha   |                              |
| /api/v0.2/traces     | Alpha   |                              |

**Metrics**

| Datadog API Endpoint        | Status      | Notes |
|-----------------------------|-------------|-------|
| /api/v1/series              | Development |       |
| /api/v2/series              | Development |       |
| /api/v1/check_run           | Development |       |
| /api/v1/sketches            | Development |       |
| /api/beta/sketches          | Development |       |
| /api/v1/distribution_points | Development |       |
| /intake                     | Development |       |

### Temporality considerations

Some backends use a different [timestamp temporality](https://opentelemetry.io/docs/specs/otel/metrics/data-model/#temporality) than Datadog uses. Both delta and cumulative temporalities are allowed in the spec.
In order to store metrics on these backends, the receiver will need to translate the timestamps.
For backends that use cumulative temporality, a [delta to cumulative processor](../../processor/deltatocumulativeprocessor/README.md) can be configured in the pipeline.
