import type { ContextOptions, DateArg } from "./types.js";
/**
 * The {@link min} function options.
 */
export interface MinOptions<DateType extends Date = Date>
  extends ContextOptions<DateType> {}
/**
 * @name min
 * @category Common Helpers
 * @summary Returns the earliest of the given dates.
 *
 * @description
 * Returns the earliest of the given dates.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param dates - The dates to compare
 *
 * @returns The earliest of the dates
 *
 * @example
 * // Which of these dates is the earliest?
 * const result = min([
 *   new Date(1989, 6, 10),
 *   new Date(1987, 1, 11),
 *   new Date(1995, 6, 2),
 *   new Date(1990, 0, 1)
 * ])
 * //=> Wed Feb 11 1987 00:00:00
 */
export declare function min<
  DateType extends Date,
  ResultDate extends Date = DateType,
>(
  dates: Array<DateArg<DateType>>,
  options?: MinOptions<ResultDate> | undefined,
): ResultDate;
