/**
 * Create a topological layering.
 */
export function topological(...args) {
    if (args.length) {
        throw new Error(`got arguments to topological(${args}), but constructor takes no arguments.`);
    }
    function topologicalCall(dag) {
        let layer = 0;
        let last;
        for (const node of dag.idescendants("before")) {
            if (last !== undefined && last.nchildLinksTo(node) > 1) {
                ++layer;
            }
            node.value = layer++;
            last = node;
        }
    }
    return topologicalCall;
}
