/**
 * A {@link LongestPathOperator} that minimizes the height of the final layout
 *
 * @packageDocumentation
 */
import { LayeringOperator } from ".";
/**
 * A {@link LayeringOperator} that minimizes the height of the final layout.
 *
 * This often results in very wide and unpleasing graphs, but is very fast. The
 * layout can go {@link topDown | top-down} or bottom-up, either assigning all roots to layer 0
 * or all leaves to the last layer.
 *
 * Create with {@link longestPath}.
 *
 * <img alt="longest path example" src="media://sugi-longestpath-opt-quad.png" width="400">
 */
export interface LongestPathOperator extends LayeringOperator<unknown, unknown> {
    /**
     * Set whether longest path should go top down or not. If set to true, the
     * longest path will start at the top, putting nodes as close to the top as
     * possible. (default: true)
     */
    topDown(val: boolean): LongestPathOperator;
    /** Get whether or not this is using topDown. */
    topDown(): boolean;
}
/**
 * Create a default {@link LongestPathOperator}, bundled as
 * {@link layeringLongestPath}.
 */
export declare function longestPath(...args: never[]): LongestPathOperator;
