import { jsx } from 'react/jsx-runtime';
import { Global } from '@emotion/react';
import { useTheme2 } from '../ThemeContext.js';
import { getAccessibilityStyles } from './accessibility.js';
import { getAlertingStyles } from './alerting.js';
import { getAgularPanelStyles } from './angularPanelStyles.js';
import { getCardStyles } from './card.js';
import { getCodeStyles } from './code.js';
import { getDashboardGridStyles } from './dashboardGrid.js';
import { getDashDiffStyles } from './dashdiff.js';
import { getElementStyles } from './elements.js';
import { getExtraStyles } from './extra.js';
import { getFilterTableStyles } from './filterTable.js';
import { getFontStyles } from './fonts.js';
import { getFormElementStyles } from './forms.js';
import { getJsonFormatterStyles } from './jsonFormatter.js';
import { getLegacySelectStyles } from './legacySelect.js';
import { getMarkdownStyles } from './markdownStyles.js';
import { getPageStyles } from './page.js';
import { getQueryEditorStyles } from './queryEditor.js';
import { getRcTimePickerStyles } from './rcTimePicker.js';
import { getSkeletonStyles } from './skeletonStyles.js';
import { getSlateStyles } from './slate.js';
import { getUplotStyles } from './uPlot.js';
import { getUtilityClassStyles } from './utilityClasses.js';

function GlobalStyles() {
  const theme = useTheme2();
  return /* @__PURE__ */ jsx(
    Global,
    {
      styles: [
        getAccessibilityStyles(),
        getAgularPanelStyles(theme),
        getAlertingStyles(theme),
        getCodeStyles(theme),
        getDashDiffStyles(theme),
        getDashboardGridStyles(theme),
        getElementStyles(theme),
        getExtraStyles(theme),
        getFilterTableStyles(theme),
        getFontStyles(),
        getFormElementStyles(theme),
        getJsonFormatterStyles(theme),
        getCardStyles(theme),
        getMarkdownStyles(theme),
        getPageStyles(theme),
        getQueryEditorStyles(theme),
        getRcTimePickerStyles(theme),
        getSkeletonStyles(),
        getSlateStyles(theme),
        getUplotStyles(),
        getUtilityClassStyles(theme),
        getLegacySelectStyles(theme)
      ]
    }
  );
}

export { GlobalStyles };
//# sourceMappingURL=GlobalStyles.js.map
