import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { Button } from '../Button/Button.js';
import '../Button/ButtonGroup.js';
import { Box } from '../Layout/Box/Box.js';
import { Stack } from '../Layout/Stack/Stack.js';
import { TextArea } from '../TextArea/TextArea.js';

const CONFIGURED_TEXT = "configured";
const RESET_BUTTON_TEXT = "Reset";
const getStyles = (theme) => {
  return {
    configuredStyle: css({
      minHeight: theme.spacing(theme.components.height.md),
      paddingTop: theme.spacing(0.5),
      resize: "none"
    })
  };
};
const SecretTextArea = ({ isConfigured, onReset, ...props }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs(Stack, { children: [
    /* @__PURE__ */ jsxs(Box, { children: [
      !isConfigured && /* @__PURE__ */ jsx(TextArea, { ...props }),
      isConfigured && /* @__PURE__ */ jsx(
        TextArea,
        {
          ...props,
          rows: 1,
          disabled: true,
          value: CONFIGURED_TEXT,
          className: cx(styles.configuredStyle)
        }
      )
    ] }),
    isConfigured && /* @__PURE__ */ jsx(Button, { onClick: onReset, variant: "secondary", children: RESET_BUTTON_TEXT })
  ] });
};

export { CONFIGURED_TEXT, RESET_BUTTON_TEXT, SecretTextArea };
//# sourceMappingURL=SecretTextArea.js.map
