import * as React from 'react';
import { textUtil } from '@grafana/data';

function RenderUserContentAsHTML({
  component,
  content,
  ...rest
}) {
  return React.createElement(component || "span", {
    dangerouslySetInnerHTML: { __html: textUtil.sanitize(content) },
    ...rest
  });
}

export { RenderUserContentAsHTML };
//# sourceMappingURL=RenderUserContentAsHTML.js.map
