import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { Spinner } from '../Spinner/Spinner.js';

const LoadingPlaceholder = ({ text, className, ...rest }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { className: cx(styles.container, className), ...rest, children: [
    text,
    " ",
    /* @__PURE__ */ jsx(Spinner, { inline: true })
  ] });
};
const getStyles = (theme) => {
  return {
    container: css({
      marginBottom: theme.spacing(4)
    })
  };
};

export { LoadingPlaceholder };
//# sourceMappingURL=LoadingPlaceholder.js.map
