import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

const Layout = ({
  children,
  orientation = 0 /* Horizontal */,
  spacing = "sm",
  justify = "flex-start",
  align = "normal",
  wrap = false,
  width = "100%",
  height = "100%",
  ...rest
}) => {
  const styles = useStyles2(getStyles, orientation, spacing, justify, align, wrap);
  return /* @__PURE__ */ jsx("div", { className: styles.layout, style: { width, height }, ...rest, children: React.Children.toArray(children).filter(Boolean).map((child, index) => {
    return /* @__PURE__ */ jsx("div", { className: styles.childWrapper, children: child }, index);
  }) });
};
const HorizontalGroup = ({
  children,
  spacing,
  justify,
  align = "center",
  wrap,
  width,
  height
}) => /* @__PURE__ */ jsx(
  Layout,
  {
    spacing,
    justify,
    orientation: 0 /* Horizontal */,
    align,
    width,
    height,
    wrap,
    children
  }
);
const VerticalGroup = ({
  children,
  spacing,
  justify,
  align,
  width,
  height
}) => /* @__PURE__ */ jsx(
  Layout,
  {
    spacing,
    justify,
    orientation: 1 /* Vertical */,
    align,
    width,
    height,
    children
  }
);
const Container = ({ children, padding, margin, grow, shrink }) => {
  const styles = useStyles2(getContainerStyles, padding, margin);
  return /* @__PURE__ */ jsx(
    "div",
    {
      className: cx(
        styles.wrapper,
        grow !== void 0 && css({ flexGrow: grow }),
        shrink !== void 0 && css({ flexShrink: shrink })
      ),
      children
    }
  );
};
const getStyles = (theme, orientation, spacing, justify, align, wrap) => {
  const finalSpacing = spacing !== "none" ? theme.spacing(spacingToNumber[spacing]) : 0;
  const marginCompensation = orientation === 0 /* Horizontal */ && !wrap || orientation === 1 /* Vertical */ ? 0 : `-${finalSpacing}`;
  const label = orientation === 1 /* Vertical */ ? "vertical-group" : "horizontal-group";
  return {
    layout: css({
      label,
      display: "flex",
      flexDirection: orientation === 1 /* Vertical */ ? "column" : "row",
      flexWrap: wrap ? "wrap" : "nowrap",
      justifyContent: justify,
      alignItems: align,
      height: "100%",
      maxWidth: "100%",
      // compensate for last row margin when wrapped, horizontal layout
      marginBottom: marginCompensation
    }),
    childWrapper: css({
      label: "layoutChildrenWrapper",
      marginBottom: orientation === 0 /* Horizontal */ && !wrap ? 0 : finalSpacing,
      marginRight: orientation === 0 /* Horizontal */ ? finalSpacing : 0,
      display: "flex",
      alignItems: align,
      "&:last-child": {
        marginBottom: orientation === 1 /* Vertical */ ? 0 : void 0,
        marginRight: orientation === 0 /* Horizontal */ ? 0 : void 0
      }
    })
  };
};
const spacingToNumber = {
  none: 0,
  xs: 0.5,
  sm: 1,
  md: 2,
  lg: 3
};
const getContainerStyles = (theme, padding, margin) => {
  const paddingSize = padding && padding !== "none" && theme.spacing(spacingToNumber[padding]) || 0;
  const marginSize = margin && margin !== "none" && theme.spacing(spacingToNumber[margin]) || 0;
  return {
    wrapper: css({
      label: "container",
      margin: marginSize,
      padding: paddingSize
    })
  };
};

export { Container, HorizontalGroup, Layout, VerticalGroup };
//# sourceMappingURL=Layout.js.map
