import { jsx } from 'react/jsx-runtime';
import '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { InlineField } from '../Forms/InlineField.js';
import { InlineSwitch } from '../Switch/Switch.js';
import { ColorPickerPopover } from './ColorPickerPopover.js';

const SeriesColorPickerPopover = (props) => {
  const { yaxis, onToggleAxis, color, ...colorPickerProps } = props;
  const customPickers = onToggleAxis ? {
    yaxis: {
      name: "Y-Axis",
      tabComponent() {
        return /* @__PURE__ */ jsx(InlineField, { labelWidth: 20, label: "Use right y-axis", children: /* @__PURE__ */ jsx(InlineSwitch, { value: yaxis === 2, label: "Use right y-axis", onChange: onToggleAxis }) });
      }
    }
  } : void 0;
  return /* @__PURE__ */ jsx(ColorPickerPopover, { ...colorPickerProps, color: color || "#000000", customPickers });
};
const SeriesColorPickerPopoverWithTheme = withTheme2(SeriesColorPickerPopover);

export { SeriesColorPickerPopover, SeriesColorPickerPopoverWithTheme };
//# sourceMappingURL=SeriesColorPickerPopover.js.map
