export declare const webStorageType: {
    readonly session: "sessionStorage";
    readonly local: "localStorage";
};
type StorageMechanism = (typeof webStorageType)[keyof typeof webStorageType];
/**
 * Check if selected web storage mechanism is available.
 * @param type storage mechanism to test availability for.
 * @returns
 */
export declare function isWebStorageAvailable(type: StorageMechanism): boolean;
/**
 * Get item from SessionStorage or LocalStorage.
 * @param key: the item key.
 * @param webStorageMechanism: wether the item shall be received form local storage or session storage. Defaults to local storage.
 */
export declare function getItem(key: string, webStorageMechanism: StorageMechanism): string | null;
/**
 * Store item in SessionStorage or LocalStorage.
 * @param key: the item key.
 * @param value: the item data.
 * @param webStorageMechanism: wether the item shall be received form local storage or session storage. Defaults to local storage.
 */
export declare function setItem(key: string, value: string, webStorageMechanism: StorageMechanism): void;
/**
 * Remove item from SessionStorage or LocalStorage.
 * @param key: the item key.
 * @param webStorageMechanism: wether the item shall be received form local storage or session storage. Defaults to local storage.
 */
export declare function removeItem(key: string, webStorageMechanism: StorageMechanism): void;
export declare const isLocalStorageAvailable: boolean;
export declare const isSessionStorageAvailable: boolean;
export {};
