"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerInitialMetas = void 0;
var sourceMaps_1 = require("../utils/sourceMaps");
var version_1 = require("../version");
function registerInitialMetas(faro) {
    var _a;
    var _b, _c;
    var initial = {
        sdk: {
            version: version_1.VERSION,
        },
        app: {
            bundleId: faro.config.app.name && (0, sourceMaps_1.getBundleId)(faro.config.app.name),
        },
    };
    var session = (_b = faro.config.sessionTracking) === null || _b === void 0 ? void 0 : _b.session;
    if (session) {
        faro.api.setSession(session);
    }
    if (faro.config.app) {
        initial.app = __assign(__assign({}, faro.config.app), initial.app);
    }
    if (faro.config.user) {
        initial.user = faro.config.user;
    }
    if (faro.config.view) {
        initial.view = faro.config.view;
    }
    (_a = faro.metas).add.apply(_a, __spreadArray([initial], ((_c = faro.config.metas) !== null && _c !== void 0 ? _c : []), false));
}
exports.registerInitialMetas = registerInitialMetas;
//# sourceMappingURL=registerInitial.js.map