"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var initialize_1 = require("./initialize");
var testUtils_1 = require("./testUtils");
describe('faro', function () {
    it("can be started paused and doesn't ingest events until unpaused", function () {
        var transport = new testUtils_1.MockTransport();
        var faro = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
            isolate: true,
            paused: true,
            transports: [transport],
        }));
        faro.api.pushLog(['test']);
        expect(transport.items).toHaveLength(0);
        faro.unpause();
        faro.api.pushLog(['test2']);
        expect(transport.items).toHaveLength(1);
        var item = transport.items[0];
        expect(item.payload.message).toEqual('test2');
    });
    it('can be started unpaused, then paused and unpaused again', function () {
        var _a, _b;
        var transport = new testUtils_1.MockTransport();
        var faro = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
            isolate: true,
            transports: [transport],
        }));
        faro.api.pushLog(['test1']);
        expect(transport.items).toHaveLength(1);
        faro.pause();
        faro.api.pushLog(['test2']);
        expect(transport.items).toHaveLength(1);
        faro.unpause();
        faro.api.pushLog(['test3']);
        var items = transport.items;
        expect((_a = items[0]) === null || _a === void 0 ? void 0 : _a.payload.message).toEqual('test1');
        expect((_b = items[1]) === null || _b === void 0 ? void 0 : _b.payload.message).toEqual('test3');
    });
});
//# sourceMappingURL=faro.test.js.map