import { cloneDeep, set } from 'lodash';
import { numberOverrideProcessor, stringOverrideProcessor, selectOverrideProcessor, booleanOverrideProcessor, identityOverrideProcessor, unitOverrideProcessor } from '../field/overrides/processors.js';
import { standardEditorsRegistry } from '../field/standardFieldConfigEditorRegistry.js';
import { OptionsUIRegistryBuilder } from '../types/OptionsUIRegistryBuilder.js';
import { isObject } from '../types/data.js';

class FieldConfigEditorBuilder extends OptionsUIRegistryBuilder {
  addNumberInput(config) {
    var _a;
    return this.addCustomEditor({
      ...config,
      id: config.path,
      override: standardEditorsRegistry.get("number").editor,
      editor: standardEditorsRegistry.get("number").editor,
      process: numberOverrideProcessor,
      shouldApply: (_a = config.shouldApply) != null ? _a : () => true,
      settings: config.settings || {}
    });
  }
  addSliderInput(config) {
    var _a;
    return this.addCustomEditor({
      ...config,
      id: config.path,
      override: standardEditorsRegistry.get("slider").editor,
      editor: standardEditorsRegistry.get("slider").editor,
      process: numberOverrideProcessor,
      shouldApply: (_a = config.shouldApply) != null ? _a : () => true,
      settings: config.settings || {}
    });
  }
  addTextInput(config) {
    var _a;
    return this.addCustomEditor({
      ...config,
      id: config.path,
      override: standardEditorsRegistry.get("text").editor,
      editor: standardEditorsRegistry.get("text").editor,
      process: stringOverrideProcessor,
      shouldApply: (_a = config.shouldApply) != null ? _a : () => true,
      settings: config.settings || {}
    });
  }
  addSelect(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      override: standardEditorsRegistry.get("select").editor,
      editor: standardEditorsRegistry.get("select").editor,
      process: selectOverrideProcessor,
      // ???
      shouldApply: config.shouldApply ? config.shouldApply : () => true,
      settings: config.settings || { options: [] }
    });
  }
  addRadio(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      override: standardEditorsRegistry.get("radio").editor,
      editor: standardEditorsRegistry.get("radio").editor,
      process: selectOverrideProcessor,
      // ???
      shouldApply: config.shouldApply ? config.shouldApply : () => true,
      settings: config.settings || { options: [] }
    });
  }
  addBooleanSwitch(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("boolean").editor,
      override: standardEditorsRegistry.get("boolean").editor,
      process: booleanOverrideProcessor,
      shouldApply: config.shouldApply ? config.shouldApply : () => true,
      settings: config.settings || {}
    });
  }
  addColorPicker(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("color").editor,
      override: standardEditorsRegistry.get("color").editor,
      process: identityOverrideProcessor,
      shouldApply: config.shouldApply ? config.shouldApply : () => true,
      settings: config.settings || {}
    });
  }
  addUnitPicker(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("unit").editor,
      override: standardEditorsRegistry.get("unit").editor,
      process: unitOverrideProcessor,
      shouldApply: config.shouldApply ? config.shouldApply : () => true,
      settings: config.settings || {}
    });
  }
  addFieldNamePicker(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("field-name").editor,
      override: standardEditorsRegistry.get("field-name").editor,
      process: identityOverrideProcessor,
      shouldApply: config.shouldApply ? config.shouldApply : () => true,
      settings: config.settings || {}
    });
  }
  addGenericEditor(config, editor) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor,
      override: editor,
      process: identityOverrideProcessor,
      shouldApply: config.shouldApply ? config.shouldApply : () => true,
      settings: config.settings || {}
    });
  }
}
class NestedPanelOptionsBuilder {
  constructor(cfg) {
    this.cfg = cfg;
    this.path = "";
    this.id = "nested-panel-options";
    this.name = "nested";
    this.editor = () => null;
    this.getBuilder = () => {
      return this.cfg.build;
    };
    this.getNestedValueAccess = (parent) => {
      const values = this.cfg.values;
      if (values) {
        return values(parent);
      }
      return {
        getValue: (path) => parent.getValue(`${this.path}.${path}`),
        onChange: (path, value) => parent.onChange(`${this.path}.${path}`, value)
      };
    };
    this.path = cfg.path;
    this.category = cfg.category;
    this.defaultValue = this.getDefaultValue(cfg);
  }
  getDefaultValue(cfg) {
    let result = isObject(cfg.defaultValue) ? cloneDeep(cfg.defaultValue) : {};
    const builder = new PanelOptionsEditorBuilder();
    cfg.build(builder, { data: [] });
    for (const item of builder.getItems()) {
      if (item.defaultValue != null) {
        set(result, item.path, item.defaultValue);
      }
    }
    return result;
  }
}
class PanelOptionsEditorBuilder extends OptionsUIRegistryBuilder {
  addNestedOptions(opts) {
    const s = new NestedPanelOptionsBuilder(opts);
    return this.addCustomEditor(s);
  }
  addNumberInput(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("number").editor
    });
  }
  addSliderInput(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("slider").editor
    });
  }
  addTextInput(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("text").editor
    });
  }
  addStringArray(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("strings").editor
    });
  }
  addSelect(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("select").editor
    });
  }
  addMultiSelect(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("multi-select").editor
    });
  }
  addRadio(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("radio").editor
    });
  }
  addBooleanSwitch(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("boolean").editor
    });
  }
  addColorPicker(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("color").editor,
      settings: config.settings || {}
    });
  }
  addTimeZonePicker(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("timezone").editor,
      settings: config.settings || {}
    });
  }
  addUnitPicker(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("unit").editor
    });
  }
  addFieldNamePicker(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("field-name").editor
    });
  }
  addDashboardPicker(config) {
    return this.addCustomEditor({
      ...config,
      id: config.path,
      editor: standardEditorsRegistry.get("dashboard-uid").editor
      // added at runtime
    });
  }
}

export { FieldConfigEditorBuilder, NestedPanelOptionsBuilder, PanelOptionsEditorBuilder };
//# sourceMappingURL=OptionsUIBuilders.js.map
