#! /bin/bash

export PDSH_SSH_ARGS='-o StrictHostKeyChecking=no'
node01=false
[ "$(hostname)" = "node01" ] && node01=true

for i in 1 2 3 4; do
    m=$(printf "node%2.2i" ${i})
    n=$(host $m)
    ssh-keyscan -4 -t ecdsa-sha2-nistp256 $m,${n##* } >> $HOME/.ssh/known_hosts
done

old=false
$node01 && { source /etc/os-release; [[ $VERSION =~ 12 ]] && old=true; }
if $old; then
    sleep 5
    pdsh -R ssh -w node0[1-4] "mount /etc/slurm"
    pdsh -R ssh -w node0[1-4] "mount /var/lib/slurm/shared"
    pdsh -R ssh -w node0[1-4] "mount /home/slurm-testsuite"
fi

$node01 && { systemctl is-enabled mariadb || systemctl enable --now mariadb; }
sleep 2
$node01 && { systemctl is-enabled slurmdbd || systemctl enable --now slurmdbd; }
sleep 2
pdsh -R ssh -w node0[1-4] "/bin/bash -c 'systemctl is-enabled slurmd || systemctl enable --now slurmd'"
sleep 2
$node01 && { systemctl is-enabled slurmctld || systemctl enable --now slurmctld; }
sleep 5
$node01 && sacctmgr -i add account slurm
$node01 && sacctmgr -i add user slurm account=slurm
