## Branching repositories

Here there is an step-by-step recipe about how to proceed when new need to branch *libyui* related repositories.

First of all, the repositories to update are the following:

* [libyui](https://github.com/libyui/libyui)
* [libyui-bindings](https://github.com/libyui/libyui-bindings)
* [libyui-ncurses](https://github.com/libyui/libyui-ncurses)
* [libyui-ncurses-pkg](https://github.com/libyui/libyui-ncurses-pkg)
* [libyui-qt](https://github.com/libyui/libyui-qt)
* [libyui-qt-pkg](https://github.com/libyui/libyui-qt-pkg)
* [libyui-qt-graph](https://github.com/libyui/libyui-qt-graph)

For every one of these repositories there is already a couple of jenkins projects to auto-submit the packages. For example, for *libyui* there are:

* [libyui-master](https://ci.suse.de/view/libyui/job/libyui-master/): which submits *master* branch to the latest SLE project in IBS.
* [libyui-sle12sp5](https://ci.suse.de/view/libyui/job/libyui-sle12sp5/): which submits *SLE-12-SP5* branch to the SLE-12-SP5 IBS project.

Actually, there are more *libyui* related packages, but those packages do not need to be branched:

* [libyui-test](https://github.com/libyui/libyui-test)
* [libyui-rest-api](https://github.com/libyui/libyui-rest-api)
* [libyui-qt-rest-api](https://github.com/libyui/libyui-qt-rest-api)
* [libyui-ncurses-rest-api](https://github.com/libyui/libyui-ncurses-rest-api)
* [libyui-gtk](https://github.com/libyui/libyui-gtk): currently maintained by the community
* [libyui-gtk-pkg](https://github.com/libyui/libyui-qt-pkg): currently maintained by the community
* [ci-libyui-container](https://github.com/libyui/ci-libyui-container): used to generate docker images with OBS directly, but not used yet
* [libyui-buildtools](https://github.com/libyui/libyui-buildtools): deprecated

### Step 1: update *libyui-rake* gem

First of all we need to add the new target for the rake task. In this case, if we are creating the SP5 branches, we have to add the following to the [targets.yml](https://github.com/libyui/libyui-rake/blob/master/data/targets.yml) file from [libyui-rake](https://github.com/libyui/libyui-rake) repository:

```
:sle12sp5:
  obs_api: "https://api.suse.de/"
  obs_project: "Devel:YaST:SLE-12-SP5"
  obs_sr_project: "SUSE:SLE-12-SP5:GA"
  obs_target: "SLE_12_SP5"
```

Then, a new gem version has to be generated by running the following commands from the root of *libyui-rake* repository:

```
gem build libyui-rake.gemspec
gem push libyui-rake-$VERSION.gem
```

Note: replace *$VERSION* with the current gem version.


### Step 2: update jenkins workers

Now we need to install the new generated *libyui-rake* gem in all our jenkins machines. For that we have Salt formulas defined in our [internal infrastructure repository](https://gitlab.suse.de/yast/infra/tree/master) at gitlab. We only have to indicate the new gem version in the [roster](https://gitlab.suse.de/yast/infra/blob/master/salt/roster) file and then run the following command from the root of this repository:

```
salt-ssh '*' -i state.apply
```

Remember to do a new merge request with the changes in the *roster* file.


### Step 3: generate a new docker image

The next thing we have to do is to generate a docker image to run the unit tests at travis. For this we simply have to add a new Dockerfile to the [docker-devel](https://github.com/libyui/docker-devel) repository. The easiest way is to copy one of the Dockerfiles the repository already contains and adapt it, see [this example](https://github.com/libyui/docker-devel/pull/10).

The rest of the process to generate the docker image is totally automatic thanks to webhooks in GitHub. So, you only have to create a PR with the new Dockerfile, and the new image will be created at [Docker Hub](https://cloud.docker.com/u/libyui/repository/docker/libyui/devel/builds) once the PR is merged.

Note: there is a [ci-libyui-container](https://github.com/libyui/ci-libyui-container) repository to use OBS for generating the docker image, but this is not used yet.


### Step 4: prepare jenkins projects

Now we have all the pieces to submit our packages to the IBS project. We only have to prepare the jenkins projects to do it.

In case we are branching because a new service pack, the easiest way is to reuse the jenkins project we already have to submit the previous service pack. For example, we can take the project *libyui-sle12sp4* and do the following:

* Rename the project according to the new service pack: *libyui-sle12sp5*
* Configure the project to listen to *SLE-12-SP5* branch instead the current *SLE-12-SP4* branch.

By reusing the previous jenkins project we are doing both: stopping automatic submittions for the previous service pack, and starting to submit the new one.

Remember we have to prepare the new jenkins project for all the *libyui* packages we are going to branch.


### Step 5: add new git branch

At this moment we are ready for branching our *libyui* repositories. For that, we can simply use *y2tool* utility provided by [yast-devtools](https://github.com/yast/yast-devtools):

```
y2tool create_maintenance_branch SLE-12-SP5 sle12sp5 origin/SLE-12-SP4
```

You have to run this command from the root of the repository you are branching.

And finally, you have to [protect the branches](https://help.github.com/en/articles/configuring-protected-branches) to require at least one review before merging.

