/*
  Copyright (C) 2021 SUSE LLC

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) version 3.0 of the License. This library
  is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
  License for more details. You should have received a copy of the GNU
  Lesser General Public License along with this library; if not, write
  to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
  Floor, Boston, MA 02110-1301 USA
*/

#ifndef YDumbTabActionHandler_h
#define YDumbTabActionHandler_h

#include <yui/YDumbTab.h>

#include "YWidgetActionHandler.h"


class YDumbTabActionHandler : public YWidgetActionHandler
{
public:

    YDumbTabActionHandler() {};
    virtual ~YDumbTabActionHandler() {};

    std::function<void (YDumbTab*)> get_handler( YDumbTab * widget,
                                                 const std::string &item_label );

private:

    YItem * findItem( const std::string &item_label, 
                      YItemConstIterator	begin,
                      YItemConstIterator	end ) const;
};

#endif // YDumbTabActionHandler_h
