; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i32 @llvm.riscv.vsetvli.i32(i32, i32, i32)
declare i64 @llvm.riscv.vsetvli.i64(i64, i64, i64)

define i32 @vsetvli_i32() nounwind {
; CHECK-LABEL: @vsetvli_i32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.vsetvli.i32(i32 1, i32 1, i32 1)
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = call i32 @llvm.riscv.vsetvli.i32(i32 1, i32 1, i32 1)
  %1 = and i32 %0, 2147483647
  ret i32 %1
}

define i64 @vsetvli_sext_i64() nounwind {
; CHECK-LABEL: @vsetvli_sext_i64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.vsetvli.i64(i64 1, i64 1, i64 1)
; CHECK-NEXT:    ret i64 [[TMP0]]
;
entry:
  %0 = call i64 @llvm.riscv.vsetvli.i64(i64 1, i64 1, i64 1)
  %1 = trunc i64 %0 to i32
  %2 = sext i32 %1 to i64
  ret i64 %2
}

define i64 @vsetvli_zext_i64() nounwind {
; CHECK-LABEL: @vsetvli_zext_i64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.vsetvli.i64(i64 1, i64 1, i64 1)
; CHECK-NEXT:    ret i64 [[TMP0]]
;
entry:
  %0 = call i64 @llvm.riscv.vsetvli.i64(i64 1, i64 1, i64 1)
  %1 = trunc i64 %0 to i32
  %2 = zext i32 %1 to i64
  ret i64 %2
}
