; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -verify-machineinstrs | FileCheck %s --check-prefix=CHECK

define i1 @saddo_not_i32(i32 %v1, i32 %v2) {
; CHECK-LABEL: saddo_not_i32:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    addl %esi, %edi
; CHECK-NEXT:    setno %al
; CHECK-NEXT:    retq
entry:
  %t = call {i32, i1} @llvm.sadd.with.overflow.i32(i32 %v1, i32 %v2)
  %obit = extractvalue {i32, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @saddo_not_i64(i64 %v1, i64 %v2) {
; CHECK-LABEL: saddo_not_i64:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    addq %rsi, %rdi
; CHECK-NEXT:    setno %al
; CHECK-NEXT:    retq
entry:
  %t = call {i64, i1} @llvm.sadd.with.overflow.i64(i64 %v1, i64 %v2)
  %obit = extractvalue {i64, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @uaddo_not_i32(i32 %v1, i32 %v2) {
; CHECK-LABEL: uaddo_not_i32:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    addl %esi, %edi
; CHECK-NEXT:    setae %al
; CHECK-NEXT:    retq
entry:
  %t = call {i32, i1} @llvm.uadd.with.overflow.i32(i32 %v1, i32 %v2)
  %obit = extractvalue {i32, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @uaddo_not_i64(i64 %v1, i64 %v2) {
; CHECK-LABEL: uaddo_not_i64:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    addq %rsi, %rdi
; CHECK-NEXT:    setae %al
; CHECK-NEXT:    retq
entry:
  %t = call {i64, i1} @llvm.uadd.with.overflow.i64(i64 %v1, i64 %v2)
  %obit = extractvalue {i64, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @ssubo_not_i32(i32 %v1, i32 %v2) {
; CHECK-LABEL: ssubo_not_i32:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    cmpl %esi, %edi
; CHECK-NEXT:    setno %al
; CHECK-NEXT:    retq
entry:
  %t = call {i32, i1} @llvm.ssub.with.overflow.i32(i32 %v1, i32 %v2)
  %obit = extractvalue {i32, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @ssub_not_i64(i64 %v1, i64 %v2) {
; CHECK-LABEL: ssub_not_i64:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    cmpq %rsi, %rdi
; CHECK-NEXT:    setno %al
; CHECK-NEXT:    retq
entry:
  %t = call {i64, i1} @llvm.ssub.with.overflow.i64(i64 %v1, i64 %v2)
  %obit = extractvalue {i64, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @usubo_not_i32(i32 %v1, i32 %v2) {
; CHECK-LABEL: usubo_not_i32:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    cmpl %esi, %edi
; CHECK-NEXT:    setae %al
; CHECK-NEXT:    retq
entry:
  %t = call {i32, i1} @llvm.usub.with.overflow.i32(i32 %v1, i32 %v2)
  %obit = extractvalue {i32, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @usubo_not_i64(i64 %v1, i64 %v2) {
; CHECK-LABEL: usubo_not_i64:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    cmpq %rsi, %rdi
; CHECK-NEXT:    setae %al
; CHECK-NEXT:    retq
entry:
  %t = call {i64, i1} @llvm.usub.with.overflow.i64(i64 %v1, i64 %v2)
  %obit = extractvalue {i64, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @smulo_not_i32(i32 %v1, i32 %v2) {
; CHECK-LABEL: smulo_not_i32:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    imull %esi, %edi
; CHECK-NEXT:    setno %al
; CHECK-NEXT:    retq
entry:
  %t = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %v1, i32 %v2)
  %obit = extractvalue {i32, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @smulo_not_i64(i64 %v1, i64 %v2) {
; CHECK-LABEL: smulo_not_i64:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    imulq %rsi, %rdi
; CHECK-NEXT:    setno %al
; CHECK-NEXT:    retq
entry:
  %t = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %v1, i64 %v2)
  %obit = extractvalue {i64, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @umulo_not_i32(i32 %v1, i32 %v2) {
; CHECK-LABEL: umulo_not_i32:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    mull %esi
; CHECK-NEXT:    setno %al
; CHECK-NEXT:    retq
entry:
  %t = call {i32, i1} @llvm.umul.with.overflow.i32(i32 %v1, i32 %v2)
  %obit = extractvalue {i32, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

define i1 @umulo_not_i64(i64 %v1, i64 %v2) {
; CHECK-LABEL: umulo_not_i64:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    mulq %rsi
; CHECK-NEXT:    setno %al
; CHECK-NEXT:    retq
entry:
  %t = call {i64, i1} @llvm.umul.with.overflow.i64(i64 %v1, i64 %v2)
  %obit = extractvalue {i64, i1} %t, 1
  %ret = xor i1 %obit, true
  ret i1 %ret
}

declare {i32, i1} @llvm.sadd.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.sadd.with.overflow.i64(i64, i64) nounwind readnone
declare {i32, i1} @llvm.uadd.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.uadd.with.overflow.i64(i64, i64) nounwind readnone
declare {i32, i1} @llvm.ssub.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.ssub.with.overflow.i64(i64, i64) nounwind readnone
declare {i32, i1} @llvm.usub.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.usub.with.overflow.i64(i64, i64) nounwind readnone
declare {i32, i1} @llvm.smul.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.smul.with.overflow.i64(i64, i64) nounwind readnone
declare {i32, i1} @llvm.umul.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.umul.with.overflow.i64(i64, i64) nounwind readnone

