/*
 * Copyright (c) 2006, 2008 SUSE LINUX Products GmbH
 * Copyright (c) 2003-2005 SuSE Linux AG Nuernberg,Germany.
 * Copyright (c) 2002 SuSE GmbH Nuernberg, Germany.
 * Author: Thorsten Kukuk <kukuk@suse.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License, in which case the provisions of the GPL are
 * required INSTEAD OF the above restrictions.  (This clause is
 * necessary due to a potential bad interaction between the GPL and
 * the restrictions contained in a BSD-style copyright.)
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <security/pam_modules.h>
#if defined (HAVE_SECURITY_PAM_EXT_H)
#include <security/pam_ext.h>
#endif

#include "public.h"

static void
parse_option (pam_handle_t *pamh, const char *argv, options_t *options)
{
  if (strcasecmp (argv, "nullok") == 0)
    options->nullok = 1;
  else if (strcasecmp (argv, "use_first_pass") == 0)
    options->use_first_pass = 1;
  else if (strcasecmp (argv, "use_authtok") == 0)
    options->use_authtok = 1;
  else if (strcasecmp (argv, "use_cracklib") == 0 ||
           strcasecmp (argv, "cracklib") == 0)
    options->use_cracklib = 1;
  else if (strncasecmp (argv, "cracklib=", 9) == 0)
    options->cracklib_path = strdup (&argv[9]);
  else if (strncasecmp (argv, "nisdir=", 7) == 0)
    options->nisdir = strdup (&argv[7]);
  else if (strcasecmp (argv, "debug") == 0)
    options->debug = 1;
  else if (strncasecmp (argv, "remember=", 9) == 0)
    {
      options->remember = strtol(&argv[9], NULL, 10);
      if (options->remember < 0)
	options->remember = 0;
      if (options->remember > 400)
	options->remember = 400;
    }
  else if (strcasecmp (argv, "no_obscure_checks") == 0)
    options->no_obscure_checks = 1;
  else if (strncasecmp (argv, "maxlen=", 7) == 0)
    options->maxlen = strtol(&argv[7], NULL, 10);
  else if (strncasecmp (argv, "minlen=", 7) == 0)
    {
      long len = strtol(&argv[7], NULL, 10);
      if (len < 0)
	options->minlen = 0;
      else
	options->minlen = len;
    }
  else if (strncasecmp (argv, "tries=", 6) == 0)
    options->tries = strtol(&argv[6], NULL, 10);
  else if (strcasecmp (argv, "enforce_for_root") == 0)
    options->enforce_for_root = 1;
  else
    pam_syslog (pamh, LOG_ERR, "pam_pwcheck: unknown option: %s", argv);
}

int
get_options (pam_handle_t *pamh, options_t *options,
	     int argc, const char **argv)
{
  /* Set some default values, which could be overwritten later.  */
  options->tries = 3;
  options->maxlen = 0;
  options->minlen = 5;

  /* Parse parameters for module */
  for ( ; argc-- > 0; argv++)
    parse_option (pamh, *argv, options);

  return 0;
}
