package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLabelset invokes the viapi_regen.DeleteLabelset API synchronously
func (client *Client) DeleteLabelset(request *DeleteLabelsetRequest) (response *DeleteLabelsetResponse, err error) {
	response = CreateDeleteLabelsetResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLabelsetWithChan invokes the viapi_regen.DeleteLabelset API asynchronously
func (client *Client) DeleteLabelsetWithChan(request *DeleteLabelsetRequest) (<-chan *DeleteLabelsetResponse, <-chan error) {
	responseChan := make(chan *DeleteLabelsetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLabelset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLabelsetWithCallback invokes the viapi_regen.DeleteLabelset API asynchronously
func (client *Client) DeleteLabelsetWithCallback(request *DeleteLabelsetRequest, callback func(response *DeleteLabelsetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLabelsetResponse
		var err error
		defer close(result)
		response, err = client.DeleteLabelset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLabelsetRequest is the request struct for api DeleteLabelset
type DeleteLabelsetRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Body" name:"Id"`
}

// DeleteLabelsetResponse is the response struct for api DeleteLabelset
type DeleteLabelsetResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteLabelsetRequest creates a request to invoke DeleteLabelset API
func CreateDeleteLabelsetRequest() (request *DeleteLabelsetRequest) {
	request = &DeleteLabelsetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "DeleteLabelset", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLabelsetResponse creates a response to parse from DeleteLabelset response
func CreateDeleteLabelsetResponse() (response *DeleteLabelsetResponse) {
	response = &DeleteLabelsetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
