package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUisConnection invokes the uis.CreateUisConnection API synchronously
// api document: https://help.aliyun.com/api/uis/createuisconnection.html
func (client *Client) CreateUisConnection(request *CreateUisConnectionRequest) (response *CreateUisConnectionResponse, err error) {
	response = CreateCreateUisConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUisConnectionWithChan invokes the uis.CreateUisConnection API asynchronously
// api document: https://help.aliyun.com/api/uis/createuisconnection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUisConnectionWithChan(request *CreateUisConnectionRequest) (<-chan *CreateUisConnectionResponse, <-chan error) {
	responseChan := make(chan *CreateUisConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUisConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUisConnectionWithCallback invokes the uis.CreateUisConnection API asynchronously
// api document: https://help.aliyun.com/api/uis/createuisconnection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUisConnectionWithCallback(request *CreateUisConnectionRequest, callback func(response *CreateUisConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUisConnectionResponse
		var err error
		defer close(result)
		response, err = client.CreateUisConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUisConnectionRequest is the request struct for api CreateUisConnection
type CreateUisConnectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Name                 string           `position:"Query" name:"Name"`
	Description          string           `position:"Query" name:"Description"`
	UisProtocol          string           `position:"Query" name:"UisProtocol"`
	SslConfig            string           `position:"Query" name:"SslConfig"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	GreConfig            string           `position:"Query" name:"GreConfig"`
}

// CreateUisConnectionResponse is the response struct for api CreateUisConnection
type CreateUisConnectionResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	UisConnectionId string `json:"UisConnectionId" xml:"UisConnectionId"`
}

// CreateCreateUisConnectionRequest creates a request to invoke CreateUisConnection API
func CreateCreateUisConnectionRequest() (request *CreateUisConnectionRequest) {
	request = &CreateUisConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "CreateUisConnection", "uis", "openAPI")
	return
}

// CreateCreateUisConnectionResponse creates a response to parse from CreateUisConnection response
func CreateCreateUisConnectionResponse() (response *CreateUisConnectionResponse) {
	response = &CreateUisConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
