package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertDevopsMember invokes the teambition_aliyun.InsertDevopsMember API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/insertdevopsmember.html
func (client *Client) InsertDevopsMember(request *InsertDevopsMemberRequest) (response *InsertDevopsMemberResponse, err error) {
	response = CreateInsertDevopsMemberResponse()
	err = client.DoAction(request, response)
	return
}

// InsertDevopsMemberWithChan invokes the teambition_aliyun.InsertDevopsMember API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/insertdevopsmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertDevopsMemberWithChan(request *InsertDevopsMemberRequest) (<-chan *InsertDevopsMemberResponse, <-chan error) {
	responseChan := make(chan *InsertDevopsMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertDevopsMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertDevopsMemberWithCallback invokes the teambition_aliyun.InsertDevopsMember API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/insertdevopsmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertDevopsMemberWithCallback(request *InsertDevopsMemberRequest, callback func(response *InsertDevopsMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertDevopsMemberResponse
		var err error
		defer close(result)
		response, err = client.InsertDevopsMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertDevopsMemberRequest is the request struct for api InsertDevopsMember
type InsertDevopsMemberRequest struct {
	*requests.RpcRequest
	Phone    string `position:"Body" name:"Phone"`
	UserPk   string `position:"Body" name:"UserPk"`
	Email    string `position:"Body" name:"Email"`
	UserName string `position:"Body" name:"UserName"`
}

// InsertDevopsMemberResponse is the response struct for api InsertDevopsMember
type InsertDevopsMemberResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Object       string `json:"Object" xml:"Object"`
}

// CreateInsertDevopsMemberRequest creates a request to invoke InsertDevopsMember API
func CreateInsertDevopsMemberRequest() (request *InsertDevopsMemberRequest) {
	request = &InsertDevopsMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "InsertDevopsMember", "", "")
	request.Method = requests.POST
	return
}

// CreateInsertDevopsMemberResponse creates a response to parse from InsertDevopsMember response
func CreateInsertDevopsMemberResponse() (response *InsertDevopsMemberResponse) {
	response = &InsertDevopsMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
