package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncProduct invokes the safe.SyncProduct API synchronously
func (client *Client) SyncProduct(request *SyncProductRequest) (response *SyncProductResponse, err error) {
	response = CreateSyncProductResponse()
	err = client.DoAction(request, response)
	return
}

// SyncProductWithChan invokes the safe.SyncProduct API asynchronously
func (client *Client) SyncProductWithChan(request *SyncProductRequest) (<-chan *SyncProductResponse, <-chan error) {
	responseChan := make(chan *SyncProductResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncProduct(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncProductWithCallback invokes the safe.SyncProduct API asynchronously
func (client *Client) SyncProductWithCallback(request *SyncProductRequest, callback func(response *SyncProductResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncProductResponse
		var err error
		defer close(result)
		response, err = client.SyncProduct(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncProductRequest is the request struct for api SyncProduct
type SyncProductRequest struct {
	*requests.RpcRequest
	AuthKey         string                        `position:"Body" name:"AuthKey"`
	ReqTimestamp    requests.Integer              `position:"Body" name:"ReqTimestamp"`
	SyncProductList *[]SyncProductSyncProductList `position:"Body" name:"SyncProductList"  type:"Repeated"`
	AuthSign        string                        `position:"Body" name:"AuthSign"`
}

// SyncProductSyncProductList is a repeated param struct in SyncProductRequest
type SyncProductSyncProductList struct {
	InnerProductList *[]SyncProductSyncProductListInnerProductList `name:"InnerProductList" type:"Repeated"`
	Code             string                                        `name:"Code"`
	Name             string                                        `name:"Name"`
}

// SyncProductSyncProductListInnerProductList is a repeated param struct in SyncProductRequest
type SyncProductSyncProductListInnerProductList struct {
	Code string `name:"Code"`
	Name string `name:"Name"`
}

// SyncProductResponse is the response struct for api SyncProduct
type SyncProductResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSyncProductRequest creates a request to invoke SyncProduct API
func CreateSyncProductRequest() (request *SyncProductRequest) {
	request = &SyncProductRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "SyncProduct", "", "")
	request.Method = requests.POST
	return
}

// CreateSyncProductResponse creates a response to parse from SyncProduct response
func CreateSyncProductResponse() (response *SyncProductResponse) {
	response = &SyncProductResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
