package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceShareAssociations invokes the resourcesharing.ListResourceShareAssociations API synchronously
func (client *Client) ListResourceShareAssociations(request *ListResourceShareAssociationsRequest) (response *ListResourceShareAssociationsResponse, err error) {
	response = CreateListResourceShareAssociationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceShareAssociationsWithChan invokes the resourcesharing.ListResourceShareAssociations API asynchronously
func (client *Client) ListResourceShareAssociationsWithChan(request *ListResourceShareAssociationsRequest) (<-chan *ListResourceShareAssociationsResponse, <-chan error) {
	responseChan := make(chan *ListResourceShareAssociationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceShareAssociations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceShareAssociationsWithCallback invokes the resourcesharing.ListResourceShareAssociations API asynchronously
func (client *Client) ListResourceShareAssociationsWithCallback(request *ListResourceShareAssociationsRequest, callback func(response *ListResourceShareAssociationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceShareAssociationsResponse
		var err error
		defer close(result)
		response, err = client.ListResourceShareAssociations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceShareAssociationsRequest is the request struct for api ListResourceShareAssociations
type ListResourceShareAssociationsRequest struct {
	*requests.RpcRequest
	NextToken         string           `position:"Query" name:"NextToken"`
	ResourceShareIds  *[]string        `position:"Query" name:"ResourceShareIds"  type:"Repeated"`
	ResourceId        string           `position:"Query" name:"ResourceId"`
	Target            string           `position:"Query" name:"Target"`
	AssociationType   string           `position:"Query" name:"AssociationType"`
	AssociationStatus string           `position:"Query" name:"AssociationStatus"`
	MaxResults        requests.Integer `position:"Query" name:"MaxResults"`
}

// ListResourceShareAssociationsResponse is the response struct for api ListResourceShareAssociations
type ListResourceShareAssociationsResponse struct {
	*responses.BaseResponse
	NextToken                 string                     `json:"NextToken" xml:"NextToken"`
	RequestId                 string                     `json:"RequestId" xml:"RequestId"`
	ResourceShareAssociations []ResourceShareAssociation `json:"ResourceShareAssociations" xml:"ResourceShareAssociations"`
}

// CreateListResourceShareAssociationsRequest creates a request to invoke ListResourceShareAssociations API
func CreateListResourceShareAssociationsRequest() (request *ListResourceShareAssociationsRequest) {
	request = &ListResourceShareAssociationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "ListResourceShareAssociations", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListResourceShareAssociationsResponse creates a response to parse from ListResourceShareAssociations response
func CreateListResourceShareAssociationsResponse() (response *ListResourceShareAssociationsResponse) {
	response = &ListResourceShareAssociationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
