package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EvaluateLocalExtendDisk invokes the rds.EvaluateLocalExtendDisk API synchronously
func (client *Client) EvaluateLocalExtendDisk(request *EvaluateLocalExtendDiskRequest) (response *EvaluateLocalExtendDiskResponse, err error) {
	response = CreateEvaluateLocalExtendDiskResponse()
	err = client.DoAction(request, response)
	return
}

// EvaluateLocalExtendDiskWithChan invokes the rds.EvaluateLocalExtendDisk API asynchronously
func (client *Client) EvaluateLocalExtendDiskWithChan(request *EvaluateLocalExtendDiskRequest) (<-chan *EvaluateLocalExtendDiskResponse, <-chan error) {
	responseChan := make(chan *EvaluateLocalExtendDiskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EvaluateLocalExtendDisk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EvaluateLocalExtendDiskWithCallback invokes the rds.EvaluateLocalExtendDisk API asynchronously
func (client *Client) EvaluateLocalExtendDiskWithCallback(request *EvaluateLocalExtendDiskRequest, callback func(response *EvaluateLocalExtendDiskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EvaluateLocalExtendDiskResponse
		var err error
		defer close(result)
		response, err = client.EvaluateLocalExtendDisk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EvaluateLocalExtendDiskRequest is the request struct for api EvaluateLocalExtendDisk
type EvaluateLocalExtendDiskRequest struct {
	*requests.RpcRequest
	DBInstanceName       string           `position:"Query" name:"DBInstanceName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Storage              requests.Integer `position:"Query" name:"Storage"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// EvaluateLocalExtendDiskResponse is the response struct for api EvaluateLocalExtendDisk
type EvaluateLocalExtendDiskResponse struct {
	*responses.BaseResponse
	RequestId             string `json:"RequestId" xml:"RequestId"`
	DBInstanceId          string `json:"DBInstanceId" xml:"DBInstanceId"`
	Available             string `json:"Available" xml:"Available"`
	LocalUpgradeDiskLimit int64  `json:"LocalUpgradeDiskLimit" xml:"LocalUpgradeDiskLimit"`
	DBInstanceTransType   string `json:"DBInstanceTransType" xml:"DBInstanceTransType"`
}

// CreateEvaluateLocalExtendDiskRequest creates a request to invoke EvaluateLocalExtendDisk API
func CreateEvaluateLocalExtendDiskRequest() (request *EvaluateLocalExtendDiskRequest) {
	request = &EvaluateLocalExtendDiskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "EvaluateLocalExtendDisk", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEvaluateLocalExtendDiskResponse creates a response to parse from EvaluateLocalExtendDisk response
func CreateEvaluateLocalExtendDiskResponse() (response *EvaluateLocalExtendDiskResponse) {
	response = &EvaluateLocalExtendDiskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
