package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemindQuotaApplicationApproval invokes the quotas.RemindQuotaApplicationApproval API synchronously
func (client *Client) RemindQuotaApplicationApproval(request *RemindQuotaApplicationApprovalRequest) (response *RemindQuotaApplicationApprovalResponse, err error) {
	response = CreateRemindQuotaApplicationApprovalResponse()
	err = client.DoAction(request, response)
	return
}

// RemindQuotaApplicationApprovalWithChan invokes the quotas.RemindQuotaApplicationApproval API asynchronously
func (client *Client) RemindQuotaApplicationApprovalWithChan(request *RemindQuotaApplicationApprovalRequest) (<-chan *RemindQuotaApplicationApprovalResponse, <-chan error) {
	responseChan := make(chan *RemindQuotaApplicationApprovalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemindQuotaApplicationApproval(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemindQuotaApplicationApprovalWithCallback invokes the quotas.RemindQuotaApplicationApproval API asynchronously
func (client *Client) RemindQuotaApplicationApprovalWithCallback(request *RemindQuotaApplicationApprovalRequest, callback func(response *RemindQuotaApplicationApprovalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemindQuotaApplicationApprovalResponse
		var err error
		defer close(result)
		response, err = client.RemindQuotaApplicationApproval(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemindQuotaApplicationApprovalRequest is the request struct for api RemindQuotaApplicationApproval
type RemindQuotaApplicationApprovalRequest struct {
	*requests.RpcRequest
	OriginalContext string `position:"Body" name:"OriginalContext"`
	ApplicationId   string `position:"Body" name:"ApplicationId"`
}

// RemindQuotaApplicationApprovalResponse is the response struct for api RemindQuotaApplicationApproval
type RemindQuotaApplicationApprovalResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string   `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string   `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrorMsg       string   `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool     `json:"Success" xml:"Success"`
	Module         string   `json:"Module" xml:"Module"`
	AllowRetry     bool     `json:"AllowRetry" xml:"AllowRetry"`
	ErrorArgs      []string `json:"ErrorArgs" xml:"ErrorArgs"`
}

// CreateRemindQuotaApplicationApprovalRequest creates a request to invoke RemindQuotaApplicationApproval API
func CreateRemindQuotaApplicationApprovalRequest() (request *RemindQuotaApplicationApprovalRequest) {
	request = &RemindQuotaApplicationApprovalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "RemindQuotaApplicationApproval", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemindQuotaApplicationApprovalResponse creates a response to parse from RemindQuotaApplicationApproval response
func CreateRemindQuotaApplicationApprovalResponse() (response *RemindQuotaApplicationApprovalResponse) {
	response = &RemindQuotaApplicationApprovalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
