package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OfflineExperimentGroup invokes the pairecservice.OfflineExperimentGroup API synchronously
func (client *Client) OfflineExperimentGroup(request *OfflineExperimentGroupRequest) (response *OfflineExperimentGroupResponse, err error) {
	response = CreateOfflineExperimentGroupResponse()
	err = client.DoAction(request, response)
	return
}

// OfflineExperimentGroupWithChan invokes the pairecservice.OfflineExperimentGroup API asynchronously
func (client *Client) OfflineExperimentGroupWithChan(request *OfflineExperimentGroupRequest) (<-chan *OfflineExperimentGroupResponse, <-chan error) {
	responseChan := make(chan *OfflineExperimentGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OfflineExperimentGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OfflineExperimentGroupWithCallback invokes the pairecservice.OfflineExperimentGroup API asynchronously
func (client *Client) OfflineExperimentGroupWithCallback(request *OfflineExperimentGroupRequest, callback func(response *OfflineExperimentGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OfflineExperimentGroupResponse
		var err error
		defer close(result)
		response, err = client.OfflineExperimentGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OfflineExperimentGroupRequest is the request struct for api OfflineExperimentGroup
type OfflineExperimentGroupRequest struct {
	*requests.RoaRequest
	Body              string `position:"Body" name:"body"`
	ExperimentGroupId string `position:"Path" name:"ExperimentGroupId"`
}

// OfflineExperimentGroupResponse is the response struct for api OfflineExperimentGroup
type OfflineExperimentGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOfflineExperimentGroupRequest creates a request to invoke OfflineExperimentGroup API
func CreateOfflineExperimentGroupRequest() (request *OfflineExperimentGroupRequest) {
	request = &OfflineExperimentGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "OfflineExperimentGroup", "/api/v1/experimentgroups/[ExperimentGroupId]/action/offline", "", "")
	request.Method = requests.POST
	return
}

// CreateOfflineExperimentGroupResponse creates a response to parse from OfflineExperimentGroup response
func CreateOfflineExperimentGroupResponse() (response *OfflineExperimentGroupResponse) {
	response = &OfflineExperimentGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
