package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RankPreviewQuery invokes the opensearch.RankPreviewQuery API synchronously
func (client *Client) RankPreviewQuery(request *RankPreviewQueryRequest) (response *RankPreviewQueryResponse, err error) {
	response = CreateRankPreviewQueryResponse()
	err = client.DoAction(request, response)
	return
}

// RankPreviewQueryWithChan invokes the opensearch.RankPreviewQuery API asynchronously
func (client *Client) RankPreviewQueryWithChan(request *RankPreviewQueryRequest) (<-chan *RankPreviewQueryResponse, <-chan error) {
	responseChan := make(chan *RankPreviewQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RankPreviewQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RankPreviewQueryWithCallback invokes the opensearch.RankPreviewQuery API asynchronously
func (client *Client) RankPreviewQueryWithCallback(request *RankPreviewQueryRequest, callback func(response *RankPreviewQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RankPreviewQueryResponse
		var err error
		defer close(result)
		response, err = client.RankPreviewQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RankPreviewQueryRequest is the request struct for api RankPreviewQuery
type RankPreviewQueryRequest struct {
	*requests.RoaRequest
	ModelName        string `position:"Path" name:"modelName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// RankPreviewQueryResponse is the response struct for api RankPreviewQuery
type RankPreviewQueryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateRankPreviewQueryRequest creates a request to invoke RankPreviewQuery API
func CreateRankPreviewQueryRequest() (request *RankPreviewQueryRequest) {
	request = &RankPreviewQueryRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "RankPreviewQuery", "/v4/openapi/app-groups/[appGroupIdentity]/algorithm/models/[modelName]/actions/query-rank", "", "")
	request.Method = requests.POST
	return
}

// CreateRankPreviewQueryResponse creates a response to parse from RankPreviewQuery response
func CreateRankPreviewQueryResponse() (response *RankPreviewQueryResponse) {
	response = &RankPreviewQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
