package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIsolationRule invokes the mse.UpdateIsolationRule API synchronously
func (client *Client) UpdateIsolationRule(request *UpdateIsolationRuleRequest) (response *UpdateIsolationRuleResponse, err error) {
	response = CreateUpdateIsolationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateIsolationRuleWithChan invokes the mse.UpdateIsolationRule API asynchronously
func (client *Client) UpdateIsolationRuleWithChan(request *UpdateIsolationRuleRequest) (<-chan *UpdateIsolationRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateIsolationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIsolationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateIsolationRuleWithCallback invokes the mse.UpdateIsolationRule API asynchronously
func (client *Client) UpdateIsolationRuleWithCallback(request *UpdateIsolationRuleRequest, callback func(response *UpdateIsolationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateIsolationRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateIsolationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateIsolationRuleRequest is the request struct for api UpdateIsolationRule
type UpdateIsolationRuleRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	Threshold      requests.Float   `position:"Query" name:"Threshold"`
	AppName        string           `position:"Query" name:"AppName"`
	Enable         requests.Boolean `position:"Query" name:"Enable"`
	AppId          string           `position:"Query" name:"AppId"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
	RuleId         requests.Integer `position:"Query" name:"RuleId"`
}

// UpdateIsolationRuleResponse is the response struct for api UpdateIsolationRule
type UpdateIsolationRuleResponse struct {
	*responses.BaseResponse
	Message   string                    `json:"Message" xml:"Message"`
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Code      string                    `json:"Code" xml:"Code"`
	Success   bool                      `json:"Success" xml:"Success"`
	Data      DataInUpdateIsolationRule `json:"Data" xml:"Data"`
}

// CreateUpdateIsolationRuleRequest creates a request to invoke UpdateIsolationRule API
func CreateUpdateIsolationRuleRequest() (request *UpdateIsolationRuleRequest) {
	request = &UpdateIsolationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateIsolationRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateIsolationRuleResponse creates a response to parse from UpdateIsolationRule response
func CreateUpdateIsolationRuleResponse() (response *UpdateIsolationRuleResponse) {
	response = &UpdateIsolationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
