package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcubeUpgradePackages invokes the mpaas.ListMcubeUpgradePackages API synchronously
func (client *Client) ListMcubeUpgradePackages(request *ListMcubeUpgradePackagesRequest) (response *ListMcubeUpgradePackagesResponse, err error) {
	response = CreateListMcubeUpgradePackagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcubeUpgradePackagesWithChan invokes the mpaas.ListMcubeUpgradePackages API asynchronously
func (client *Client) ListMcubeUpgradePackagesWithChan(request *ListMcubeUpgradePackagesRequest) (<-chan *ListMcubeUpgradePackagesResponse, <-chan error) {
	responseChan := make(chan *ListMcubeUpgradePackagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcubeUpgradePackages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcubeUpgradePackagesWithCallback invokes the mpaas.ListMcubeUpgradePackages API asynchronously
func (client *Client) ListMcubeUpgradePackagesWithCallback(request *ListMcubeUpgradePackagesRequest, callback func(response *ListMcubeUpgradePackagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcubeUpgradePackagesResponse
		var err error
		defer close(result)
		response, err = client.ListMcubeUpgradePackages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcubeUpgradePackagesRequest is the request struct for api ListMcubeUpgradePackages
type ListMcubeUpgradePackagesRequest struct {
	*requests.RpcRequest
	TenantId    string `position:"Body" name:"TenantId"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// ListMcubeUpgradePackagesResponse is the response struct for api ListMcubeUpgradePackages
type ListMcubeUpgradePackagesResponse struct {
	*responses.BaseResponse
	ResultMessage      string             `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode         string             `json:"ResultCode" xml:"ResultCode"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	ListPackagesResult ListPackagesResult `json:"ListPackagesResult" xml:"ListPackagesResult"`
}

// CreateListMcubeUpgradePackagesRequest creates a request to invoke ListMcubeUpgradePackages API
func CreateListMcubeUpgradePackagesRequest() (request *ListMcubeUpgradePackagesRequest) {
	request = &ListMcubeUpgradePackagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcubeUpgradePackages", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcubeUpgradePackagesResponse creates a response to parse from ListMcubeUpgradePackages response
func CreateListMcubeUpgradePackagesResponse() (response *ListMcubeUpgradePackagesResponse) {
	response = &ListMcubeUpgradePackagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
