package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDeviceGroup invokes the lto.DisableDeviceGroup API synchronously
func (client *Client) DisableDeviceGroup(request *DisableDeviceGroupRequest) (response *DisableDeviceGroupResponse, err error) {
	response = CreateDisableDeviceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDeviceGroupWithChan invokes the lto.DisableDeviceGroup API asynchronously
func (client *Client) DisableDeviceGroupWithChan(request *DisableDeviceGroupRequest) (<-chan *DisableDeviceGroupResponse, <-chan error) {
	responseChan := make(chan *DisableDeviceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDeviceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDeviceGroupWithCallback invokes the lto.DisableDeviceGroup API asynchronously
func (client *Client) DisableDeviceGroupWithCallback(request *DisableDeviceGroupRequest, callback func(response *DisableDeviceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDeviceGroupResponse
		var err error
		defer close(result)
		response, err = client.DisableDeviceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDeviceGroupRequest is the request struct for api DisableDeviceGroup
type DisableDeviceGroupRequest struct {
	*requests.RpcRequest
	DeviceGroupId string `position:"Query" name:"DeviceGroupId"`
}

// DisableDeviceGroupResponse is the response struct for api DisableDeviceGroup
type DisableDeviceGroupResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDisableDeviceGroupRequest creates a request to invoke DisableDeviceGroup API
func CreateDisableDeviceGroupRequest() (request *DisableDeviceGroupRequest) {
	request = &DisableDeviceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DisableDeviceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableDeviceGroupResponse creates a response to parse from DisableDeviceGroup response
func CreateDisableDeviceGroupResponse() (response *DisableDeviceGroupResponse) {
	response = &DisableDeviceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
