package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendLiveMessageGroup invokes the live.SendLiveMessageGroup API synchronously
func (client *Client) SendLiveMessageGroup(request *SendLiveMessageGroupRequest) (response *SendLiveMessageGroupResponse, err error) {
	response = CreateSendLiveMessageGroupResponse()
	err = client.DoAction(request, response)
	return
}

// SendLiveMessageGroupWithChan invokes the live.SendLiveMessageGroup API asynchronously
func (client *Client) SendLiveMessageGroupWithChan(request *SendLiveMessageGroupRequest) (<-chan *SendLiveMessageGroupResponse, <-chan error) {
	responseChan := make(chan *SendLiveMessageGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendLiveMessageGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendLiveMessageGroupWithCallback invokes the live.SendLiveMessageGroup API asynchronously
func (client *Client) SendLiveMessageGroupWithCallback(request *SendLiveMessageGroupRequest, callback func(response *SendLiveMessageGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendLiveMessageGroupResponse
		var err error
		defer close(result)
		response, err = client.SendLiveMessageGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendLiveMessageGroupRequest is the request struct for api SendLiveMessageGroup
type SendLiveMessageGroupRequest struct {
	*requests.RpcRequest
	SenderMetaInfo  string           `position:"Query" name:"SenderMetaInfo"`
	Body            string           `position:"Query" name:"Body"`
	StaticsIncrease requests.Integer `position:"Query" name:"StaticsIncrease"`
	NoCache         requests.Boolean `position:"Query" name:"NoCache"`
	MsgType         requests.Integer `position:"Query" name:"MsgType"`
	NoStorage       requests.Boolean `position:"Query" name:"NoStorage"`
	GroupId         string           `position:"Query" name:"GroupId"`
	Weight          requests.Integer `position:"Query" name:"Weight"`
	DataCenter      string           `position:"Query" name:"DataCenter"`
	MsgTid          string           `position:"Query" name:"MsgTid"`
	SenderId        string           `position:"Query" name:"SenderId"`
	AppId           string           `position:"Query" name:"AppId"`
}

// SendLiveMessageGroupResponse is the response struct for api SendLiveMessageGroup
type SendLiveMessageGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSendLiveMessageGroupRequest creates a request to invoke SendLiveMessageGroup API
func CreateSendLiveMessageGroupRequest() (request *SendLiveMessageGroupRequest) {
	request = &SendLiveMessageGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SendLiveMessageGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendLiveMessageGroupResponse creates a response to parse from SendLiveMessageGroup response
func CreateSendLiveMessageGroupResponse() (response *SendLiveMessageGroupResponse) {
	response = &SendLiveMessageGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
