package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartTranscodeTask invokes the live.RestartTranscodeTask API synchronously
func (client *Client) RestartTranscodeTask(request *RestartTranscodeTaskRequest) (response *RestartTranscodeTaskResponse, err error) {
	response = CreateRestartTranscodeTaskResponse()
	err = client.DoAction(request, response)
	return
}

// RestartTranscodeTaskWithChan invokes the live.RestartTranscodeTask API asynchronously
func (client *Client) RestartTranscodeTaskWithChan(request *RestartTranscodeTaskRequest) (<-chan *RestartTranscodeTaskResponse, <-chan error) {
	responseChan := make(chan *RestartTranscodeTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartTranscodeTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartTranscodeTaskWithCallback invokes the live.RestartTranscodeTask API asynchronously
func (client *Client) RestartTranscodeTaskWithCallback(request *RestartTranscodeTaskRequest, callback func(response *RestartTranscodeTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartTranscodeTaskResponse
		var err error
		defer close(result)
		response, err = client.RestartTranscodeTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartTranscodeTaskRequest is the request struct for api RestartTranscodeTask
type RestartTranscodeTaskRequest struct {
	*requests.RpcRequest
	TranscodingTemplate string `position:"Query" name:"TranscodingTemplate"`
	SecurityToken       string `position:"Query" name:"SecurityToken"`
	PushDomain          string `position:"Query" name:"PushDomain"`
	StreamName          string `position:"Query" name:"StreamName"`
	App                 string `position:"Query" name:"App"`
}

// RestartTranscodeTaskResponse is the response struct for api RestartTranscodeTask
type RestartTranscodeTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRestartTranscodeTaskRequest creates a request to invoke RestartTranscodeTask API
func CreateRestartTranscodeTaskRequest() (request *RestartTranscodeTaskRequest) {
	request = &RestartTranscodeTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "RestartTranscodeTask", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestartTranscodeTaskResponse creates a response to parse from RestartTranscodeTask response
func CreateRestartTranscodeTaskResponse() (response *RestartTranscodeTaskResponse) {
	response = &RestartTranscodeTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
