package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamPreloadTasks invokes the live.DescribeLiveStreamPreloadTasks API synchronously
func (client *Client) DescribeLiveStreamPreloadTasks(request *DescribeLiveStreamPreloadTasksRequest) (response *DescribeLiveStreamPreloadTasksResponse, err error) {
	response = CreateDescribeLiveStreamPreloadTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamPreloadTasksWithChan invokes the live.DescribeLiveStreamPreloadTasks API asynchronously
func (client *Client) DescribeLiveStreamPreloadTasksWithChan(request *DescribeLiveStreamPreloadTasksRequest) (<-chan *DescribeLiveStreamPreloadTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamPreloadTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamPreloadTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamPreloadTasksWithCallback invokes the live.DescribeLiveStreamPreloadTasks API asynchronously
func (client *Client) DescribeLiveStreamPreloadTasksWithCallback(request *DescribeLiveStreamPreloadTasksRequest, callback func(response *DescribeLiveStreamPreloadTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamPreloadTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamPreloadTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamPreloadTasksRequest is the request struct for api DescribeLiveStreamPreloadTasks
type DescribeLiveStreamPreloadTasksRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNum    requests.Integer `position:"Query" name:"PageNum"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	TaskId     string           `position:"Query" name:"TaskId"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	PlayUrl    string           `position:"Query" name:"PlayUrl"`
	Status     string           `position:"Query" name:"Status"`
}

// DescribeLiveStreamPreloadTasksResponse is the response struct for api DescribeLiveStreamPreloadTasks
type DescribeLiveStreamPreloadTasksResponse struct {
	*responses.BaseResponse
	PageNum      int          `json:"PageNum" xml:"PageNum"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	TotalNum     int          `json:"TotalNum" xml:"TotalNum"`
	TotalPage    int          `json:"TotalPage" xml:"TotalPage"`
	PreloadTasks PreloadTasks `json:"PreloadTasks" xml:"PreloadTasks"`
}

// CreateDescribeLiveStreamPreloadTasksRequest creates a request to invoke DescribeLiveStreamPreloadTasks API
func CreateDescribeLiveStreamPreloadTasksRequest() (request *DescribeLiveStreamPreloadTasksRequest) {
	request = &DescribeLiveStreamPreloadTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamPreloadTasks", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamPreloadTasksResponse creates a response to parse from DescribeLiveStreamPreloadTasks response
func CreateDescribeLiveStreamPreloadTasksResponse() (response *DescribeLiveStreamPreloadTasksResponse) {
	response = &DescribeLiveStreamPreloadTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
