package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveAISubtitle invokes the live.DeleteLiveAISubtitle API synchronously
func (client *Client) DeleteLiveAISubtitle(request *DeleteLiveAISubtitleRequest) (response *DeleteLiveAISubtitleResponse, err error) {
	response = CreateDeleteLiveAISubtitleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveAISubtitleWithChan invokes the live.DeleteLiveAISubtitle API asynchronously
func (client *Client) DeleteLiveAISubtitleWithChan(request *DeleteLiveAISubtitleRequest) (<-chan *DeleteLiveAISubtitleResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveAISubtitleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveAISubtitle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveAISubtitleWithCallback invokes the live.DeleteLiveAISubtitle API asynchronously
func (client *Client) DeleteLiveAISubtitleWithCallback(request *DeleteLiveAISubtitleRequest, callback func(response *DeleteLiveAISubtitleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveAISubtitleResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveAISubtitle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveAISubtitleRequest is the request struct for api DeleteLiveAISubtitle
type DeleteLiveAISubtitleRequest struct {
	*requests.RpcRequest
	SubtitleName string           `position:"Query" name:"SubtitleName"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	SubtitleId   string           `position:"Query" name:"SubtitleId"`
}

// DeleteLiveAISubtitleResponse is the response struct for api DeleteLiveAISubtitle
type DeleteLiveAISubtitleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveAISubtitleRequest creates a request to invoke DeleteLiveAISubtitle API
func CreateDeleteLiveAISubtitleRequest() (request *DeleteLiveAISubtitleRequest) {
	request = &DeleteLiveAISubtitleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveAISubtitle", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveAISubtitleResponse creates a response to parse from DeleteLiveAISubtitle response
func CreateDeleteLiveAISubtitleResponse() (response *DeleteLiveAISubtitleResponse) {
	response = &DeleteLiveAISubtitleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
