package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRecordByRecordId invokes the linkvisual.QueryRecordByRecordId API synchronously
func (client *Client) QueryRecordByRecordId(request *QueryRecordByRecordIdRequest) (response *QueryRecordByRecordIdResponse, err error) {
	response = CreateQueryRecordByRecordIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRecordByRecordIdWithChan invokes the linkvisual.QueryRecordByRecordId API asynchronously
func (client *Client) QueryRecordByRecordIdWithChan(request *QueryRecordByRecordIdRequest) (<-chan *QueryRecordByRecordIdResponse, <-chan error) {
	responseChan := make(chan *QueryRecordByRecordIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRecordByRecordId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRecordByRecordIdWithCallback invokes the linkvisual.QueryRecordByRecordId API asynchronously
func (client *Client) QueryRecordByRecordIdWithCallback(request *QueryRecordByRecordIdRequest, callback func(response *QueryRecordByRecordIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRecordByRecordIdResponse
		var err error
		defer close(result)
		response, err = client.QueryRecordByRecordId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRecordByRecordIdRequest is the request struct for api QueryRecordByRecordId
type QueryRecordByRecordIdRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	RecordId      string `position:"Query" name:"RecordId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// QueryRecordByRecordIdResponse is the response struct for api QueryRecordByRecordId
type QueryRecordByRecordIdResponse struct {
	*responses.BaseResponse
	Code         string     `json:"Code" xml:"Code"`
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	ErrorMessage string     `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool       `json:"Success" xml:"Success"`
	Data         []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryRecordByRecordIdRequest creates a request to invoke QueryRecordByRecordId API
func CreateQueryRecordByRecordIdRequest() (request *QueryRecordByRecordIdRequest) {
	request = &QueryRecordByRecordIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryRecordByRecordId", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRecordByRecordIdResponse creates a response to parse from QueryRecordByRecordId response
func CreateQueryRecordByRecordIdResponse() (response *QueryRecordByRecordIdResponse) {
	response = &QueryRecordByRecordIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
