package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRtmpKey invokes the linkvisual.DeleteRtmpKey API synchronously
func (client *Client) DeleteRtmpKey(request *DeleteRtmpKeyRequest) (response *DeleteRtmpKeyResponse, err error) {
	response = CreateDeleteRtmpKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRtmpKeyWithChan invokes the linkvisual.DeleteRtmpKey API asynchronously
func (client *Client) DeleteRtmpKeyWithChan(request *DeleteRtmpKeyRequest) (<-chan *DeleteRtmpKeyResponse, <-chan error) {
	responseChan := make(chan *DeleteRtmpKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRtmpKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRtmpKeyWithCallback invokes the linkvisual.DeleteRtmpKey API asynchronously
func (client *Client) DeleteRtmpKeyWithCallback(request *DeleteRtmpKeyRequest, callback func(response *DeleteRtmpKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRtmpKeyResponse
		var err error
		defer close(result)
		response, err = client.DeleteRtmpKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRtmpKeyRequest is the request struct for api DeleteRtmpKey
type DeleteRtmpKeyRequest struct {
	*requests.RpcRequest
	Type          requests.Integer `position:"Query" name:"Type"`
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// DeleteRtmpKeyResponse is the response struct for api DeleteRtmpKey
type DeleteRtmpKeyResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteRtmpKeyRequest creates a request to invoke DeleteRtmpKey API
func CreateDeleteRtmpKeyRequest() (request *DeleteRtmpKeyRequest) {
	request = &DeleteRtmpKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeleteRtmpKey", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteRtmpKeyResponse creates a response to parse from DeleteRtmpKey response
func CreateDeleteRtmpKeyResponse() (response *DeleteRtmpKeyResponse) {
	response = &DeleteRtmpKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
